/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.Transformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CacheableTransformer
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0016J\u001c\u0010\"\u001a\u00020\u00002\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u00128WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/ManifestResourceTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/Transformer;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "<init>", "(Lorg/gradle/api/model/ObjectFactory;)V", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "manifestDiscovered", "", "manifest", "Ljava/util/jar/Manifest;", "mainClass", "Lorg/gradle/api/provider/Property;", "", "getMainClass", "()Lorg/gradle/api/provider/Property;", "manifestEntries", "Lorg/gradle/api/provider/MapProperty;", "Ljava/util/jar/Attributes;", "getManifestEntries", "()Lorg/gradle/api/provider/MapProperty;", "canTransformResource", "element", "Lorg/gradle/api/file/FileTreeElement;", "transform", "", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "hasTransformedResource", "modifyOutputStream", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "attributes", "", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nManifestResourceTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestResourceTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/ManifestResourceTransformer\n+ 2 GradleCompat.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/GradleCompatKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,95:1\n50#2,11:96\n74#2,11:107\n216#3,2:118\n*S KotlinDebug\n*F\n+ 1 ManifestResourceTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/ManifestResourceTransformer\n*L\n40#1:96,11\n44#1:107,11\n77#1:118,2\n*E\n"})
public class ManifestResourceTransformer
implements Transformer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectFactory objectFactory;
    private boolean manifestDiscovered;
    @Nullable
    private Manifest manifest;
    @NotNull
    private final Property<String> mainClass;
    @NotNull
    private final MapProperty<String, Attributes> manifestEntries;
    private static final Logger logger = LoggerFactory.getLogger(ManifestResourceTransformer.class);

    @Inject
    public ManifestResourceTransformer(@NotNull ObjectFactory objectFactory) {
        Property property;
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        ObjectFactory $this$property_u24default$iv = this.objectFactory = objectFactory;
        Object defaultValue$iv = null;
        boolean $i$f$property = false;
        Property $this$property_u24lambda_u240$iv = property = $this$property_u24default$iv.property(String.class);
        boolean bl = false;
        Property property2 = property;
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"apply(...)");
        this.mainClass = property2;
        ObjectFactory $this$mapProperty_u24default$iv = this.objectFactory;
        defaultValue$iv = null;
        boolean $i$f$mapProperty = false;
        Property $this$mapProperty_u24lambda_u242$iv = property = $this$mapProperty_u24default$iv.mapProperty(String.class, Attributes.class);
        boolean bl2 = false;
        Property property3 = property;
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"apply(...)");
        this.manifestEntries = property3;
    }

    @Override
    @NotNull
    public final ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Optional
    @Input
    @NotNull
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Optional
    @Input
    @NotNull
    public MapProperty<String, Attributes> getManifestEntries() {
        return this.manifestEntries;
    }

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String path = element.getRelativePath().getPathString();
        return StringsKt.equals((String)"META-INF/MANIFEST.MF", (String)path, (boolean)true);
    }

    @Override
    public void transform(@NotNull TransformerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.manifestDiscovered) {
            try {
                this.manifest = new Manifest(context.getInputStream());
                this.manifestDiscovered = true;
            }
            catch (IOException e) {
                logger.warn("Failed to read MANIFEST.MF", (Throwable)e);
            }
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return true;
    }

    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        Manifest manifest = this.manifest;
        Intrinsics.checkNotNull((Object)manifest);
        Attributes attributes = manifest.getMainAttributes();
        String string = (String)this.getMainClass().getOrNull();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)attributes);
            ((Map)attributes).put(Attributes.Name.MAIN_CLASS, it);
        }
        Object object = this.getManifestEntries().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Map $this$forEach$iv = (Map)object;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            Attributes value = (Attributes)entry.getValue();
            Intrinsics.checkNotNull((Object)attributes);
            ((Map)attributes).put(new Attributes.Name(key), value);
        }
        ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
        entry.setTime(TransformerContext.Companion.getEntryTimestamp(preserveFileTimestamps, entry.getTime()));
        os.putNextEntry(entry);
        Manifest manifest2 = this.manifest;
        Intrinsics.checkNotNull((Object)manifest2);
        manifest2.write((OutputStream)os);
    }

    @NotNull
    public ManifestResourceTransformer attributes(@NotNull Map<String, ? extends Attributes> attributes) {
        ManifestResourceTransformer manifestResourceTransformer;
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        ManifestResourceTransformer $this$attributes_u24lambda_u242 = manifestResourceTransformer = this;
        boolean bl = false;
        $this$attributes_u24lambda_u242.getManifestEntries().putAll(attributes);
        return manifestResourceTransformer;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/ManifestResourceTransformer$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "shadow"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

