/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.internal;

import com.github.jengelman.gradle.plugins.shadow.ShadowStats;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocateClassContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocatePathContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowCopyAction;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.commons.Remapper;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011J\u0012\u0010\u0013\u001a\u00020\u00112\n\u0010\u0014\u001a\u00060\u0015R\u00020\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/internal/RelocatorRemapper;", "Lorg/objectweb/asm/commons/Remapper;", "relocators", "", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "stats", "Lcom/github/jengelman/gradle/plugins/shadow/ShadowStats;", "<init>", "(Ljava/util/Set;Lcom/github/jengelman/gradle/plugins/shadow/ShadowStats;)V", "classPattern", "Ljava/util/regex/Pattern;", "hasRelocators", "", "mapValue", "", "value", "map", "", "name", "mapPath", "path", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$RelativeArchivePath;", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction;", "shadow"})
public final class RelocatorRemapper
extends Remapper {
    @NotNull
    private final Set<Relocator> relocators;
    @NotNull
    private final ShadowStats stats;
    @NotNull
    private final Pattern classPattern;

    public RelocatorRemapper(@NotNull Set<? extends Relocator> relocators, @NotNull ShadowStats stats) {
        Intrinsics.checkNotNullParameter(relocators, (String)"relocators");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        this.relocators = relocators;
        this.stats = stats;
        Pattern pattern = Pattern.compile("(\\[*)?L(.+)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.classPattern = pattern;
    }

    public final boolean hasRelocators() {
        return !((Collection)this.relocators).isEmpty();
    }

    @NotNull
    public Object mapValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value instanceof String ? this.map((String)value) : super.mapValue(value);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    @NotNull
    public String map(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String newName = name;
        Object prefix = "";
        String suffix = "";
        Matcher matcher = this.classPattern.matcher(newName);
        if (matcher.matches()) {
            prefix = matcher.group(1) + "L";
            suffix = "";
            newName = matcher.group(2);
        }
        for (Relocator relocator : this.relocators) {
            if (relocator.canRelocateClass(newName)) {
                RelocateClassContext classContext = new RelocateClassContext(newName, this.stats);
                return (String)prefix + relocator.relocateClass(classContext) + suffix;
            }
            if (!relocator.canRelocatePath(newName)) continue;
            RelocatePathContext pathContext = new RelocatePathContext(newName, this.stats);
            return (String)prefix + relocator.relocatePath(pathContext) + suffix;
        }
        return name;
    }

    @NotNull
    public final String mapPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = path.substring(0, StringsKt.indexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return this.map(string);
    }

    @NotNull
    public final String mapPath(@NotNull ShadowCopyAction.RelativeArchivePath path) {
        Intrinsics.checkNotNullParameter((Object)((Object)path), (String)"path");
        String string = path.getPathString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathString(...)");
        return this.mapPath(string);
    }
}

