/*
 * Decompiled with CFR 0.152.
 */
package jpprof;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.zip.GZIPOutputStream;
import jpprof.jfr2pprof;
import jpprof.one.jfr.JfrReader;
import jpprof.one.profiler.AsyncProfiler;

public class CPUProfiler {
    private static final File tmpDir;
    private static final String nativeLibPath;

    public static void start(Duration duration, OutputStream out) throws IOException, InterruptedException {
        File jfrFile = File.createTempFile("profile-", "jfr", tmpDir);
        AsyncProfiler instance = AsyncProfiler.getInstance(nativeLibPath);
        instance.execute(CPUProfiler.buildStartCommand(jfrFile.getAbsolutePath()));
        Thread.sleep(duration.toMillis());
        instance.stop();
        try (JfrReader jfrReader = new JfrReader(jfrFile.getAbsolutePath());
             GZIPOutputStream outgzip = new GZIPOutputStream(out);){
            jfr2pprof.Convert(jfrReader, outgzip);
        }
        jfrFile.delete();
    }

    private static String copyLibrary() throws Exception {
        String embeddedLibPrefix = "/async-profiler-libs/libasyncProfiler";
        String embeddedLibSuffix = CPUProfiler.getLibrarySuffix();
        InputStream is = CPUProfiler.class.getResourceAsStream(embeddedLibPrefix + embeddedLibSuffix);
        if (is == null) {
            return System.getProperty("user.dir") + "/async-profiler-2.8.3/libasyncProfiler" + CPUProfiler.getLibrarySuffix();
        }
        Path libCopyPath = new File(tmpDir, "libasyncProfiler.so").toPath().toAbsolutePath();
        Files.copy(is, libCopyPath, StandardCopyOption.REPLACE_EXISTING);
        return libCopyPath.toString();
    }

    private static String getLibrarySuffix() throws Exception {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String embeddedLibSuffix = "";
        block4 : switch (osName) {
            case "linux": {
                switch (osArch) {
                    case "amd64": {
                        embeddedLibSuffix = "-linux-x64.so";
                        break block4;
                    }
                    case "aarch64": {
                        embeddedLibSuffix = "-linux-arm64.so";
                        break block4;
                    }
                }
                throw new Exception("Unsupported Linux arch: " + osArch);
            }
            case "mac os x": {
                switch (osArch) {
                    case "x86_64": 
                    case "aarch64": {
                        embeddedLibSuffix = "-macos.so";
                        break block4;
                    }
                }
                throw new Exception("Unsupported OSX arch: " + osArch);
            }
            default: {
                throw new Exception("Unsupported OS: " + osName);
            }
        }
        return embeddedLibSuffix;
    }

    private static String buildStartCommand(String dst) {
        StringBuilder sb = new StringBuilder();
        sb.append("start,event=").append("cpu");
        sb.append(",interval=").append(10);
        sb.append(",file=").append(dst).append(",jfr");
        return sb.toString();
    }

    static {
        try {
            tmpDir = Files.createTempDirectory("jpprof-", new FileAttribute[0]).toFile();
            nativeLibPath = CPUProfiler.copyLibrary();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

