/*
 * Decompiled with CFR 0.152.
 */
package jpprof;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import jpprof.CPUProfiler;
import jpprof.com.google.common.base.Splitter;

public class PprofHttpHandler
implements HttpHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange t) throws IOException {
        String path = t.getRequestURI().getPath();
        if (!path.equals("/debug/pprof/profile")) {
            t.sendResponseHeaders(404, 0L);
            t.close();
            return;
        }
        Map<String, String> map = Splitter.on('&').trimResults().withKeyValueSeparator('=').split(t.getRequestURI().getRawQuery());
        Duration duration = Duration.ofSeconds(Integer.parseInt(map.get("seconds")));
        try {
            t.getRequestBody().close();
            t.getResponseHeaders().set("Content-Encoding", "gzip");
            t.sendResponseHeaders(200, 0L);
            CPUProfiler.start(duration, t.getResponseBody());
        }
        catch (Exception e) {
            t.sendResponseHeaders(500, 0L);
            return;
        }
        finally {
            t.close();
        }
    }
}

