/*
 * Decompiled with CFR 0.152.
 */
package jpprof;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jpprof.one.jfr.ClassRef;
import jpprof.one.jfr.Dictionary;
import jpprof.one.jfr.JfrReader;
import jpprof.one.jfr.MethodRef;
import jpprof.one.jfr.StackTrace;
import jpprof.one.jfr.event.ExecutionSample;
import jpprof.one.proto.Proto;

public class jfr2pprof {
    public static final byte[] METHOD_UNKNOWN = "[unknown]".getBytes();
    public static final int PROFILE_SAMPLE_TYPE = 1;
    public static final int PROFILE_SAMPLE = 2;
    public static final int PROFILE_LOCATION = 4;
    public static final int PROFILE_FUNCTION = 5;
    public static final int PROFILE_STRING_TABLE = 6;
    public static final int PROFILE_TIME_NANOS = 9;
    public static final int PROFILE_DURATION_NANOS = 10;
    public static final int PROFILE_PERIOD_TYPE = 11;
    public static final int PROFILE_COMMENT = 13;
    public static final int PROFILE_DEFAULT_SAMPLE_TYPE = 14;
    public static final int VALUETYPE_TYPE = 1;
    public static final int VALUETYPE_UNIT = 2;
    public static final int SAMPLE_LOCATION_ID = 1;
    public static final int SAMPLE_VALUE = 2;
    public static final int LOCATION_ID = 1;
    public static final int LOCATION_LINE = 4;
    public static final int LINE_FUNCTION_ID = 1;
    public static final int LINE_LINE = 2;
    public static final int FUNCTION_ID = 1;
    public static final int FUNCTION_NAME = 2;

    public static void Convert(JfrReader reader, OutputStream out) throws IOException {
        int functionId = 1;
        int locationId = 1;
        int stringId = 1;
        HashMap<Method, Integer> functions = new HashMap<Method, Integer>();
        HashMap<Method, Integer> locations = new HashMap<Method, Integer>();
        Proto profile = new Proto(200000).field(9, reader.startNanos).field(10, reader.durationNanos()).field(14, 0L).field(6, "".getBytes(StandardCharsets.UTF_8)).field(6, "async-profiler".getBytes(StandardCharsets.UTF_8)).field(13, stringId++);
        Proto sampleType = new Proto(100);
        profile.field(6, "cpu".getBytes(StandardCharsets.UTF_8));
        sampleType.field(1, stringId++);
        profile.field(6, "nanoseconds".getBytes(StandardCharsets.UTF_8));
        sampleType.field(2, stringId++);
        profile.field(1, sampleType);
        profile.field(11, sampleType);
        List<ExecutionSample> jfrSamples = reader.readAllEvents(ExecutionSample.class);
        Dictionary<StackTrace> stackTraces = reader.stackTraces;
        long previousTime = reader.startTicks;
        for (ExecutionSample jfrSample : jfrSamples) {
            StackTrace stackTrace = stackTraces.get(jfrSample.stackTraceId);
            long[] methods = stackTrace.methods;
            byte[] types = stackTrace.types;
            long nanosSinceLastSample = (jfrSample.time - previousTime) * 1000000000L / reader.ticksPerSec;
            Proto sample = new Proto(1000).field(2, nanosSinceLastSample);
            for (int current = 0; current < methods.length; ++current) {
                Integer locaId;
                byte methodType = types[current];
                long methodIdentifier = methods[current];
                byte[] methodName = jfr2pprof.getMethodName(reader, methodIdentifier, methodType);
                Method method = new Method(methodName);
                int line = stackTrace.locations[current] >>> 16;
                Integer methodId = (Integer)functions.get(method);
                if (null == methodId) {
                    int funcId = functionId++;
                    profile.field(6, methodName);
                    Proto function = new Proto(16).field(1, funcId).field(2, stringId++);
                    profile.field(5, function);
                    functions.put(method, funcId);
                }
                if (null == (locaId = (Integer)locations.get(method))) {
                    int locId = locationId++;
                    Proto locLine = new Proto(16).field(1, (Integer)functions.get(method));
                    if (line > 0) {
                        locLine.field(2, line);
                    }
                    Proto location = new Proto(16).field(1, locId).field(4, locLine);
                    profile.field(4, location);
                    locations.put(method, locId);
                }
                sample.field(1, (Integer)locations.get(method));
            }
            profile.field(2, sample);
            previousTime = jfrSample.time;
        }
        out.write(profile.buffer(), 0, profile.size());
    }

    private static byte[] getMethodName(JfrReader reader, long methodId, byte methodType) {
        MethodRef ref = reader.methods.get(methodId);
        if (null == ref) {
            return METHOD_UNKNOWN;
        }
        ClassRef classRef = reader.classes.get(ref.cls);
        byte[] className = reader.symbols.get(classRef.name);
        byte[] methodName = reader.symbols.get(ref.name);
        if (methodType >= 3 && methodType <= 5 || className == null || className.length == 0) {
            return methodName;
        }
        byte[] fullName = new byte[className.length + 1 + methodName.length];
        System.arraycopy(className, 0, fullName, 0, className.length);
        fullName[className.length] = 46;
        System.arraycopy(methodName, 0, fullName, className.length + 1, methodName.length);
        return fullName;
    }

    public static class Method {
        final byte[] name;

        public Method(byte[] name) {
            this.name = name;
        }

        public int hashCode() {
            return Arrays.hashCode(this.name);
        }

        public boolean equals(Object other) {
            return other instanceof Method && Arrays.equals(this.name, ((Method)other).name);
        }
    }
}

