/*
 * Decompiled with CFR 0.152.
 */
package jpprof.one.profiler;

import java.io.IOException;
import jpprof.one.profiler.AsyncProfilerMXBean;
import jpprof.one.profiler.Counter;

public class AsyncProfiler
implements AsyncProfilerMXBean {
    private static AsyncProfiler instance;

    private AsyncProfiler() {
    }

    public static AsyncProfiler getInstance() {
        return AsyncProfiler.getInstance(null);
    }

    public static synchronized AsyncProfiler getInstance(String string) {
        if (instance != null) {
            return instance;
        }
        AsyncProfiler asyncProfiler = new AsyncProfiler();
        if (string != null) {
            System.load(string);
        } else {
            try {
                asyncProfiler.getVersion();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.loadLibrary("asyncProfiler");
            }
        }
        instance = asyncProfiler;
        return asyncProfiler;
    }

    @Override
    public void start(String string, long l) throws IllegalStateException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.start0(string, l, true);
    }

    @Override
    public void resume(String string, long l) throws IllegalStateException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.start0(string, l, false);
    }

    @Override
    public void stop() throws IllegalStateException {
        this.stop0();
    }

    @Override
    public native long getSamples();

    @Override
    public String getVersion() {
        try {
            return this.execute0("version");
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public String execute(String string) throws IllegalArgumentException, IllegalStateException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.execute0(string);
    }

    @Override
    public String dumpCollapsed(Counter counter) {
        try {
            return this.execute0("collapsed," + counter.name().toLowerCase());
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public String dumpTraces(int n) {
        try {
            return this.execute0(n == 0 ? "traces" : "traces=" + n);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public String dumpFlat(int n) {
        try {
            return this.execute0(n == 0 ? "flat" : "flat=" + n);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public void addThread(Thread thread) {
        this.filterThread(thread, true);
    }

    public void removeThread(Thread thread) {
        this.filterThread(thread, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterThread(Thread thread, boolean bl) {
        if (thread == null || thread == Thread.currentThread()) {
            this.filterThread0(null, bl);
        } else {
            Thread thread2 = thread;
            synchronized (thread2) {
                Thread.State state = thread.getState();
                if (state != Thread.State.NEW && state != Thread.State.TERMINATED) {
                    this.filterThread0(thread, bl);
                }
            }
        }
    }

    private native void start0(String var1, long var2, boolean var4) throws IllegalStateException;

    private native void stop0() throws IllegalStateException;

    private native String execute0(String var1) throws IllegalArgumentException, IllegalStateException, IOException;

    private native void filterThread0(Thread var1, boolean var2);
}

