/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.predicate;

import com.graphaware.common.description.BasePartiallyComparable;
import com.graphaware.common.description.predicate.Or;
import com.graphaware.common.description.predicate.Predicate;
import com.graphaware.common.description.predicate.UndefinedValue;
import com.graphaware.common.util.ArrayUtils;

abstract class BasePredicate
extends BasePartiallyComparable<Predicate>
implements Predicate {
    BasePredicate() {
    }

    @Override
    protected Predicate self() {
        return this;
    }

    @Override
    public boolean isMoreGeneralThan(Predicate other) {
        if (other instanceof Or) {
            return this.isMoreGeneralThan(((Or)other).getFirst()) && this.isMoreGeneralThan(((Or)other).getSecond());
        }
        return false;
    }

    @Override
    public boolean isMutuallyExclusive(Predicate other) {
        if (other instanceof Or) {
            return this.isMutuallyExclusive(((Or)other).getFirst()) && this.isMutuallyExclusive(((Or)other).getSecond());
        }
        return false;
    }

    protected final void checkValueIsLegal(Object value) {
        if (!(this.isPrimitiveOrString(value) || ArrayUtils.isPrimitiveOrStringArray(value) || UndefinedValue.getInstance().equals(value))) {
            throw new IllegalArgumentException("Value must be a primitive, a String, an array of primitives, or an array of Strings");
        }
    }

    private boolean isPrimitiveOrString(Object o) {
        if (o instanceof Byte) {
            return true;
        }
        if (o instanceof Character) {
            return true;
        }
        if (o instanceof Boolean) {
            return true;
        }
        if (o instanceof Long) {
            return true;
        }
        if (o instanceof Double) {
            return true;
        }
        if (o instanceof Integer) {
            return true;
        }
        if (o instanceof Short) {
            return true;
        }
        if (o instanceof Float) {
            return true;
        }
        return o instanceof String;
    }
}

