/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.predicate;

import com.graphaware.common.description.predicate.ValueBasedPredicate;
import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.util.ArrayUtils;
import org.neo4j.logging.Log;

abstract class ComparablePredicate
extends ValueBasedPredicate<Comparable> {
    private static final Log LOG = LoggerFactory.getLogger(ComparablePredicate.class);

    protected ComparablePredicate(Comparable value) {
        super(value);
    }

    protected final boolean isLessThan(Object value) {
        if (!this.isComparable(value)) {
            return false;
        }
        try {
            return ((Comparable)this.getValue()).compareTo(value) < 0;
        }
        catch (ClassCastException e) {
            LOG.warn(String.valueOf(this.getValue()) + " cannot be compared to " + String.valueOf(value));
            return false;
        }
    }

    protected final boolean isLessThanOrEqualTo(Object value) {
        return this.isLessThan(value) || ArrayUtils.arrayFriendlyEquals(this.getValue(), value);
    }

    protected final boolean isGreaterThan(Object value) {
        if (!this.isComparable(value)) {
            return false;
        }
        try {
            return ((Comparable)this.getValue()).compareTo(value) > 0;
        }
        catch (ClassCastException e) {
            LOG.warn(String.valueOf(this.getValue()) + " cannot be compared to " + String.valueOf(value));
            return false;
        }
    }

    protected final boolean isGreaterThanOrEqualTo(Object value) {
        return this.isGreaterThan(value) || ArrayUtils.arrayFriendlyEquals(this.getValue(), value);
    }

    protected final boolean isComparable(Object value) {
        return value instanceof Comparable;
    }
}

