/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.predicate;

import com.graphaware.common.description.predicate.Predicate;
import com.graphaware.common.description.predicate.ValueBasedPredicate;
import com.graphaware.common.util.ArrayUtils;

class EqualTo
extends ValueBasedPredicate<Object> {
    EqualTo(Object value) {
        super(value);
    }

    @Override
    public boolean evaluate(Object beta) {
        this.checkValueIsLegal(beta);
        return ArrayUtils.arrayFriendlyEquals(this.getValue(), beta);
    }

    @Override
    public boolean isMoreGeneralThan(Predicate other) {
        return super.isMoreGeneralThan(other) || other instanceof EqualTo && ArrayUtils.arrayFriendlyEquals(this.getValue(), ((EqualTo)other).getValue());
    }

    @Override
    public boolean isMutuallyExclusive(Predicate other) {
        if (super.isMutuallyExclusive(other)) {
            return true;
        }
        if (other instanceof EqualTo) {
            return !ArrayUtils.arrayFriendlyEquals(this.getValue(), ((EqualTo)other).getValue());
        }
        return other.isMutuallyExclusive(this);
    }

    public String toString() {
        return "=" + this.getValue();
    }
}

