/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.predicate;

import com.graphaware.common.description.predicate.ComparablePredicate;
import com.graphaware.common.description.predicate.EqualTo;
import com.graphaware.common.description.predicate.LessThan;
import com.graphaware.common.description.predicate.Predicate;
import com.graphaware.common.description.predicate.ValueBasedPredicate;
import com.graphaware.common.util.ArrayUtils;

final class GreaterThan
extends ComparablePredicate {
    GreaterThan(Comparable value) {
        super(value);
    }

    @Override
    public boolean evaluate(Object beta) {
        this.checkValueIsLegal(beta);
        return this.isLessThan(beta);
    }

    @Override
    public boolean isMoreGeneralThan(Predicate other) {
        if (super.isMoreGeneralThan(other)) {
            return true;
        }
        if (!(other instanceof ValueBasedPredicate)) {
            return false;
        }
        if (other instanceof EqualTo) {
            return this.isLessThan(((EqualTo)other).getValue());
        }
        if (other instanceof GreaterThan) {
            return this.isLessThan(((GreaterThan)other).getValue()) || ArrayUtils.arrayFriendlyEquals(this.getValue(), ((GreaterThan)other).getValue());
        }
        return false;
    }

    @Override
    public boolean isMutuallyExclusive(Predicate other) {
        if (super.isMutuallyExclusive(other)) {
            return true;
        }
        if (other instanceof LessThan || other instanceof EqualTo) {
            return !this.isLessThan(((ValueBasedPredicate)other).getValue());
        }
        return other instanceof GreaterThan && !this.isGreaterThanOrEqualTo(((ValueBasedPredicate)other).getValue()) && !this.isLessThanOrEqualTo(((ValueBasedPredicate)other).getValue());
    }

    public String toString() {
        return ">" + this.getValue();
    }
}

