/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.predicate;

import com.graphaware.common.description.predicate.ComparablePredicate;
import com.graphaware.common.description.predicate.EqualTo;
import com.graphaware.common.description.predicate.GreaterThan;
import com.graphaware.common.description.predicate.Predicate;
import com.graphaware.common.description.predicate.ValueBasedPredicate;
import com.graphaware.common.util.ArrayUtils;

final class LessThan
extends ComparablePredicate {
    LessThan(Comparable value) {
        super(value);
    }

    @Override
    public boolean evaluate(Object beta) {
        this.checkValueIsLegal(beta);
        return this.isGreaterThan(beta);
    }

    @Override
    public boolean isMoreGeneralThan(Predicate other) {
        if (super.isMoreGeneralThan(other)) {
            return true;
        }
        if (!(other instanceof ValueBasedPredicate)) {
            return false;
        }
        if (other instanceof EqualTo) {
            return this.isGreaterThan(((EqualTo)other).getValue());
        }
        if (other instanceof LessThan) {
            return this.isGreaterThan(((LessThan)other).getValue()) || ArrayUtils.arrayFriendlyEquals(this.getValue(), ((LessThan)other).getValue());
        }
        return false;
    }

    @Override
    public boolean isMutuallyExclusive(Predicate other) {
        if (super.isMutuallyExclusive(other)) {
            return true;
        }
        if (other instanceof GreaterThan || other instanceof EqualTo) {
            return !this.isGreaterThan(((ValueBasedPredicate)other).getValue());
        }
        return other instanceof LessThan && !this.isGreaterThanOrEqualTo(((ValueBasedPredicate)other).getValue()) && !this.isLessThanOrEqualTo(((ValueBasedPredicate)other).getValue());
    }

    public String toString() {
        return "<" + this.getValue();
    }
}

