/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.predicate;

import com.graphaware.common.description.predicate.BasePredicate;
import com.graphaware.common.description.predicate.Predicate;

final class Or
extends BasePredicate {
    private final Predicate first;
    private final Predicate second;

    Or(Predicate first, Predicate second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean evaluate(Object beta) {
        return this.first.evaluate(beta) || this.second.evaluate(beta);
    }

    @Override
    public boolean isMoreGeneralThan(Predicate other) {
        if (super.isMoreGeneralThan(other)) {
            return true;
        }
        return this.first.isMoreGeneralThan(other) || this.second.isMoreGeneralThan(other);
    }

    @Override
    public boolean isMutuallyExclusive(Predicate other) {
        if (super.isMutuallyExclusive(other)) {
            return true;
        }
        return this.first.isMutuallyExclusive(other) && this.second.isMutuallyExclusive(other);
    }

    Predicate getFirst() {
        return this.first;
    }

    Predicate getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Or or = (Or)o;
        if (!this.first.equals(or.first)) {
            return false;
        }
        return this.second.equals(or.second);
    }

    public int hashCode() {
        int result = this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        return result;
    }

    public String toString() {
        return this.getFirst().toString() + "||" + this.getSecond().toString();
    }
}

