/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.predicate;

import com.esotericsoftware.kryo.Kryo;
import com.graphaware.common.description.predicate.Any;
import com.graphaware.common.description.predicate.EqualTo;
import com.graphaware.common.description.predicate.GreaterThan;
import com.graphaware.common.description.predicate.LessThan;
import com.graphaware.common.description.predicate.Or;
import com.graphaware.common.description.predicate.Predicate;
import com.graphaware.common.description.predicate.Undefined;
import com.graphaware.common.description.predicate.UndefinedValue;

public final class Predicates {
    private Predicates() {
    }

    public static Predicate any() {
        return Any.getInstance();
    }

    public static Predicate undefined() {
        return Undefined.getInstance();
    }

    public static Predicate equalTo(Object value) {
        return new EqualTo(value);
    }

    public static Predicate greaterThan(Comparable value) {
        return new GreaterThan(value);
    }

    public static Predicate greaterThanOrEqualTo(Comparable value) {
        return new Or(new GreaterThan(value), new EqualTo(value));
    }

    public static Predicate lessThan(Comparable value) {
        return new LessThan(value);
    }

    public static Predicate lessThanOrEqualTo(Comparable value) {
        return new Or(new LessThan(value), new EqualTo(value));
    }

    public static void register(Kryo kryo) {
        kryo.register(Any.class, 20);
        kryo.register(EqualTo.class, 21);
        kryo.register(GreaterThan.class, 22);
        kryo.register(LessThan.class, 23);
        kryo.register(Or.class, 24);
        kryo.register(Undefined.class, 25);
        kryo.register(UndefinedValue.class, 26);
    }
}

