/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.property;

import com.graphaware.common.description.predicate.Predicate;
import com.graphaware.common.description.predicate.Predicates;
import com.graphaware.common.description.property.BasePropertiesDescription;
import com.graphaware.common.description.property.DetachedPropertiesDescription;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.graphdb.Entity;

public abstract class BaseDetachedPropertiesDescription
extends BasePropertiesDescription
implements DetachedPropertiesDescription {
    protected final Map<String, Predicate> predicates = new TreeMap<String, Predicate>();

    protected BaseDetachedPropertiesDescription(Entity entity) {
        for (String key : entity.getPropertyKeys()) {
            this.predicates.put(key, Predicates.equalTo(entity.getProperty(key)));
        }
    }

    protected BaseDetachedPropertiesDescription(Map<String, Predicate> predicates) {
        this.predicates.putAll(predicates);
    }

    @Override
    public DetachedPropertiesDescription with(String propertyKey, Predicate predicate) {
        HashMap<String, Predicate> newPredicates = new HashMap<String, Predicate>(this.predicates);
        newPredicates.put(propertyKey, predicate);
        return this.newInstance(newPredicates);
    }

    protected abstract DetachedPropertiesDescription newInstance(Map<String, Predicate> var1);

    @Override
    public Predicate get(String key) {
        if (!this.predicates.containsKey(key)) {
            return this.undefined();
        }
        return this.predicates.get(key);
    }

    protected abstract Predicate undefined();

    @Override
    public Iterable<String> getKeys() {
        return this.predicates.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseDetachedPropertiesDescription that = (BaseDetachedPropertiesDescription)o;
        return this.predicates.equals(that.predicates);
    }

    public int hashCode() {
        return this.predicates.hashCode();
    }
}

