/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.property;

import com.graphaware.common.description.predicate.Predicate;
import com.graphaware.common.description.predicate.Predicates;
import com.graphaware.common.description.property.BasePropertiesDescription;
import com.graphaware.common.description.property.PropertiesDescription;
import org.neo4j.graphdb.Entity;

public class LazyPropertiesDescription
extends BasePropertiesDescription
implements PropertiesDescription {
    private final Entity entity;

    public LazyPropertiesDescription(Entity entity) {
        this.entity = entity;
    }

    @Override
    public Predicate get(String key) {
        Object value = this.entity.getProperty(key, null);
        if (value == null) {
            return Predicates.undefined();
        }
        return Predicates.equalTo(value);
    }

    @Override
    public Iterable<String> getKeys() {
        return this.entity.getPropertyKeys();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyPropertiesDescription that = (LazyPropertiesDescription)o;
        return this.entity.equals(that.entity);
    }

    public int hashCode() {
        return this.entity.hashCode();
    }
}

