/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.relationship;

import com.graphaware.common.description.BasePartiallyComparable;
import com.graphaware.common.description.property.PropertiesDescription;
import com.graphaware.common.description.relationship.RelationshipDescription;
import com.graphaware.common.util.DirectionUtils;
import org.neo4j.graphdb.Direction;

public abstract class BaseRelationshipDescription<P extends PropertiesDescription>
extends BasePartiallyComparable<RelationshipDescription>
implements RelationshipDescription {
    private final String relationshipType;
    private final Direction direction;
    private final P propertiesDescription;

    protected BaseRelationshipDescription(String relationshipType, Direction direction, P propertiesDescription) {
        this.relationshipType = relationshipType;
        this.direction = direction;
        this.propertiesDescription = propertiesDescription;
    }

    @Override
    public boolean isMoreGeneralThan(RelationshipDescription other) {
        return this.getType().equals(other.getType()) && DirectionUtils.matches(this.getDirection(), other.getDirection()) && this.getPropertiesDescription().isMoreGeneralThan((PropertiesDescription)other.getPropertiesDescription());
    }

    @Override
    public boolean isMutuallyExclusive(RelationshipDescription other) {
        return !this.getType().equals(other.getType()) || !DirectionUtils.matches(this.getDirection(), other.getDirection()) || this.getPropertiesDescription().isMutuallyExclusive((PropertiesDescription)other.getPropertiesDescription());
    }

    @Override
    protected RelationshipDescription self() {
        return this;
    }

    @Override
    public String getType() {
        return this.relationshipType;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    public P getPropertiesDescription() {
        return this.propertiesDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseRelationshipDescription that = (BaseRelationshipDescription)o;
        if (this.direction != that.direction) {
            return false;
        }
        if (!this.propertiesDescription.equals(that.propertiesDescription)) {
            return false;
        }
        return this.relationshipType.equals(that.relationshipType);
    }

    public int hashCode() {
        int result = this.relationshipType.hashCode();
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.propertiesDescription.hashCode();
        return result;
    }
}

