/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.description.relationship;

import com.graphaware.common.description.property.LiteralPropertiesDescription;
import com.graphaware.common.description.property.WildcardPropertiesDescription;
import com.graphaware.common.description.relationship.DetachedRelationshipDescription;
import com.graphaware.common.description.relationship.DetachedRelationshipDescriptionImpl;
import com.graphaware.common.util.DirectionUtils;
import java.util.Collections;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class RelationshipDescriptionFactory {
    private RelationshipDescriptionFactory() {
    }

    public static DetachedRelationshipDescription literal(Relationship relationship, Node pointOfView) {
        return new DetachedRelationshipDescriptionImpl(relationship.getType().name(), DirectionUtils.resolveDirection(relationship, pointOfView), new LiteralPropertiesDescription((Entity)relationship));
    }

    public static DetachedRelationshipDescription literal(RelationshipType type, Direction direction) {
        return new DetachedRelationshipDescriptionImpl(type.name(), direction, new LiteralPropertiesDescription(Collections.emptyMap()));
    }

    public static DetachedRelationshipDescription literal(String type, Direction direction) {
        return new DetachedRelationshipDescriptionImpl(type, direction, new LiteralPropertiesDescription(Collections.emptyMap()));
    }

    public static DetachedRelationshipDescription wildcard(Relationship relationship, Node pointOfView) {
        return new DetachedRelationshipDescriptionImpl(relationship.getType().name(), DirectionUtils.resolveDirection(relationship, pointOfView), new WildcardPropertiesDescription((Entity)relationship));
    }

    public static DetachedRelationshipDescription wildcard(RelationshipType type, Direction direction) {
        return new DetachedRelationshipDescriptionImpl(type.name(), direction, new WildcardPropertiesDescription(Collections.emptyMap()));
    }

    public static DetachedRelationshipDescription wildcard(String type, Direction direction) {
        return new DetachedRelationshipDescriptionImpl(type, direction, new WildcardPropertiesDescription(Collections.emptyMap()));
    }
}

