/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.expression;

import com.graphaware.common.expression.AttachedNodeExpressions;
import com.graphaware.common.expression.DetachedRelationshipExpressions;
import com.graphaware.common.util.DirectionUtils;
import org.neo4j.graphdb.Direction;

public interface AttachedRelationshipExpressions<N extends AttachedNodeExpressions>
extends DetachedRelationshipExpressions {
    public N getStartNode();

    public N getEndNode();

    public N pointOfView();

    default public N getOtherNode() {
        if (this.pointOfView() == null) {
            throw new IllegalStateException("Relationship expression contains a reference to other node, but no reference is provided to this node.");
        }
        if (this.pointOfView().equals(this.getStartNode())) {
            return this.getEndNode();
        }
        if (this.pointOfView().equals(this.getEndNode())) {
            return this.getStartNode();
        }
        throw new IllegalStateException("Neither start node nor end node are the point of view. This is a bug");
    }

    default public boolean isOutgoing() {
        if (this.pointOfView() == null) {
            throw new IllegalStateException("Relationship expression contains a direction, but no information is available as to which node is looking.");
        }
        return Direction.OUTGOING.equals((Object)DirectionUtils.resolveDirection(this, this.pointOfView(), Direction.OUTGOING));
    }

    default public boolean isIncoming() {
        if (this.pointOfView() == null) {
            throw new IllegalStateException("Relationship expression contains a direction, but no information is available as to which node is looking.");
        }
        return Direction.INCOMING.equals((Object)DirectionUtils.resolveDirection(this, this.pointOfView(), Direction.OUTGOING));
    }
}

