/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.log;

import java.io.OutputStream;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;

public final class LoggerFactory
extends KernelExtensionFactory<Dependencies> {
    private static LogProvider LOG_PROVIDER = FormattedLogProvider.toOutputStream((OutputStream)System.out);

    public static Log getLogger(Class<?> clazz) {
        return LOG_PROVIDER.getLog(clazz);
    }

    public LoggerFactory() {
        super("graphaware-logging");
    }

    public Lifecycle newInstance(KernelContext context, final Dependencies dependencies) {
        return new LifecycleAdapter(){

            public void init() throws Throwable {
                LOG_PROVIDER = dependencies.logger().getUserLogProvider();
            }
        };
    }

    public static interface Dependencies {
        public LogService logger();
    }
}

