/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.ping;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.ping.StatsCollector;
import com.graphaware.common.util.VersionReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.Edition;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;
import org.neo4j.util.concurrent.DecayingFlags;
import org.neo4j.util.concurrent.RecentK;

public class GoogleAnalyticsStatsCollector
implements StatsCollector {
    private static final Log LOG = LoggerFactory.getLogger(GoogleAnalyticsStatsCollector.class);
    private static final String TID = "UA-1428985-11";
    private static final String UNKNOWN = "unknown";
    private final GraphDatabaseService database;
    private static ScheduledExecutorService executor;
    private String storeId = "unknown";
    private final String version;
    private UsageData usageData;
    private IdGeneratorFactory idGeneratorFactory;
    private Config config;

    public GoogleAnalyticsStatsCollector(GraphDatabaseService database) {
        if (database instanceof GraphDatabaseFacade) {
            GraphDatabaseFacade graphDatabaseFacade = (GraphDatabaseFacade)database;
            this.usageData = (UsageData)graphDatabaseFacade.getDependencyResolver().resolveDependency(UsageData.class, DependencyResolver.SelectionStrategy.FIRST);
            this.idGeneratorFactory = (IdGeneratorFactory)graphDatabaseFacade.getDependencyResolver().resolveDependency(IdGeneratorFactory.class, DependencyResolver.SelectionStrategy.FIRST);
        }
        this.database = database;
        this.version = VersionReader.getVersion();
    }

    public GoogleAnalyticsStatsCollector(GraphDatabaseService database, Config config) {
        this(database);
        this.config = config;
    }

    private String findStoreIdIfNeeded() {
        if (UNKNOWN.equals(this.storeId)) {
            try {
                this.storeId = this.findStoreId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.storeId;
    }

    private String findStoreId() {
        if (this.database == null) {
            return UNKNOWN;
        }
        if (((GraphDatabaseAPI)this.database).storeId() == null) {
            return UNKNOWN;
        }
        return String.valueOf(((GraphDatabaseAPI)this.database).storeId().getRandomId());
    }

    @Override
    public void frameworkStart(String edition) {
        this.post("framework-" + edition);
    }

    @Override
    public void runtimeStart() {
        this.post("runtime");
    }

    @Override
    public void moduleStart(String moduleClassName) {
        this.post(moduleClassName);
    }

    private void post(String appId) {
        this.initializeExecutorIfNeeded();
        executor.scheduleAtFixedRate(() -> {
            HttpPost httpPost = new HttpPost("http://www.google-analytics.com/collect");
            httpPost.setEntity((HttpEntity)new StringEntity(this.constructBody(this.findStoreIdIfNeeded(), appId), ContentType.TEXT_PLAIN));
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                httpClient.execute((HttpUriRequest)httpPost);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExecutorIfNeeded() {
        if (executor == null) {
            GoogleAnalyticsStatsCollector googleAnalyticsStatsCollector = this;
            synchronized (googleAnalyticsStatsCollector) {
                if (executor == null) {
                    executor = Executors.newSingleThreadScheduledExecutor();
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            executor.shutdownNow();
                        }
                    });
                }
            }
        }
    }

    private String constructBody(String storeId, String appId) {
        String usageDataInfo = this.constructUsageDataInfo();
        String otherInfo = this.collectOtherInfo();
        return "v=1&tid=UA-1428985-11&cid=" + storeId + "&t=event&ea=" + appId + "&ec=Run&el=" + this.version + usageDataInfo + otherInfo;
    }

    private String constructUsageDataInfo() {
        if (this.usageData != null) {
            Edition edition = (Edition)this.usageData.get(UsageDataKeys.edition);
            RecentK clientNames = (RecentK)this.usageData.get(UsageDataKeys.clientNames);
            List clientNamesList = Collections.emptyList();
            if (clientNames != null) {
                clientNamesList = StreamSupport.stream(clientNames.spliterator(), false).collect(Collectors.toList());
            }
            DecayingFlags features = (DecayingFlags)this.usageData.get(UsageDataKeys.features);
            OperationalMode operationalMode = (OperationalMode)this.usageData.get(UsageDataKeys.operationalMode);
            String revision = (String)this.usageData.get(UsageDataKeys.revision);
            String serverId = (String)this.usageData.get(UsageDataKeys.serverId);
            String neo4jVersion = (String)this.usageData.get(UsageDataKeys.version);
            return "&cd1=" + edition.name() + "&cd2=" + operationalMode.name() + "&cd3=" + revision + "&cd4=" + serverId + "&cd5=" + neo4jVersion + "&cd6=" + clientNamesList.toString() + "&cd7=" + (features == null ? "" : features.asHex());
        }
        return "";
    }

    private String collectOtherInfo() {
        String udcSource = (String)this.config.get(UdcSettings.udc_source);
        String udcRegistrationKey = (String)this.config.get(UdcSettings.udc_registration_key);
        String os = System.getProperties().getProperty("os.name");
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        long totalMemory = OsBeanUtil.getTotalPhysicalMemory();
        long heapSize = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        long nodeIdsInUse = this.getNumberOfIdsInUse(IdType.NODE);
        long propertyIdsInUse = this.getNumberOfIdsInUse(IdType.PROPERTY);
        long relationshipIdsInUse = this.getNumberOfIdsInUse(IdType.RELATIONSHIP);
        long labelIdsInUse = this.getNumberOfIdsInUse(IdType.LABEL_TOKEN);
        return "&cd8=" + udcSource + "&cd9=" + udcRegistrationKey + "&cd10=" + os + "&cd11=" + availableProcessors + "&cd12=" + totalMemory + "&cd13=" + heapSize + "&cd14=" + nodeIdsInUse + "&cd15=" + propertyIdsInUse + "&cd16=" + relationshipIdsInUse + "&cd17=" + labelIdsInUse;
    }

    private long getNumberOfIdsInUse(IdType type) {
        return this.idGeneratorFactory.get(type).getNumberOfIdsInUse();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleAnalyticsStatsCollector that = (GoogleAnalyticsStatsCollector)o;
        return !(this.storeId == null ? that.storeId != null : !this.storeId.equals(that.storeId));
    }

    public int hashCode() {
        return this.storeId != null ? this.storeId.hashCode() : 0;
    }
}

