/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.policy.inclusion;

import com.graphaware.common.policy.inclusion.NodeInclusionPolicy;
import com.graphaware.common.policy.inclusion.NodePropertyInclusionPolicy;
import com.graphaware.common.policy.inclusion.RelationshipInclusionPolicy;
import com.graphaware.common.policy.inclusion.RelationshipPropertyInclusionPolicy;
import com.graphaware.common.policy.inclusion.all.IncludeAllNodeProperties;
import com.graphaware.common.policy.inclusion.all.IncludeAllNodes;
import com.graphaware.common.policy.inclusion.all.IncludeAllRelationshipProperties;
import com.graphaware.common.policy.inclusion.all.IncludeAllRelationships;
import com.graphaware.common.policy.inclusion.none.IncludeNoNodeProperties;
import com.graphaware.common.policy.inclusion.none.IncludeNoNodes;
import com.graphaware.common.policy.inclusion.none.IncludeNoRelationshipProperties;
import com.graphaware.common.policy.inclusion.none.IncludeNoRelationships;

public class InclusionPolicies {
    private final NodeInclusionPolicy nodeInclusionPolicy;
    private final NodePropertyInclusionPolicy nodePropertyInclusionPolicy;
    private final RelationshipInclusionPolicy relationshipInclusionPolicy;
    private final RelationshipPropertyInclusionPolicy relationshipPropertyInclusionPolicy;

    public static InclusionPolicies all() {
        return new InclusionPolicies(IncludeAllNodes.getInstance(), IncludeAllNodeProperties.getInstance(), IncludeAllRelationships.getInstance(), IncludeAllRelationshipProperties.getInstance());
    }

    public static InclusionPolicies none() {
        return new InclusionPolicies(IncludeNoNodes.getInstance(), IncludeNoNodeProperties.getInstance(), IncludeNoRelationships.getInstance(), IncludeNoRelationshipProperties.getInstance());
    }

    public InclusionPolicies(NodeInclusionPolicy nodeInclusionPolicy, NodePropertyInclusionPolicy nodePropertyInclusionPolicy, RelationshipInclusionPolicy relationshipInclusionPolicy, RelationshipPropertyInclusionPolicy relationshipPropertyInclusionPolicy) {
        if (nodeInclusionPolicy == null || nodePropertyInclusionPolicy == null || relationshipInclusionPolicy == null || relationshipPropertyInclusionPolicy == null) {
            throw new IllegalArgumentException("An inclusion policy must not be null");
        }
        this.nodeInclusionPolicy = nodeInclusionPolicy;
        this.nodePropertyInclusionPolicy = nodePropertyInclusionPolicy;
        this.relationshipInclusionPolicy = relationshipInclusionPolicy;
        this.relationshipPropertyInclusionPolicy = relationshipPropertyInclusionPolicy;
    }

    public InclusionPolicies with(NodeInclusionPolicy nodeInclusionPolicy) {
        return new InclusionPolicies(nodeInclusionPolicy, this.getNodePropertyInclusionPolicy(), this.getRelationshipInclusionPolicy(), this.getRelationshipPropertyInclusionPolicy());
    }

    public InclusionPolicies with(NodePropertyInclusionPolicy nodePropertyInclusionPolicy) {
        return new InclusionPolicies(this.getNodeInclusionPolicy(), nodePropertyInclusionPolicy, this.getRelationshipInclusionPolicy(), this.getRelationshipPropertyInclusionPolicy());
    }

    public InclusionPolicies with(RelationshipInclusionPolicy relationshipInclusionPolicy) {
        return new InclusionPolicies(this.getNodeInclusionPolicy(), this.getNodePropertyInclusionPolicy(), relationshipInclusionPolicy, this.getRelationshipPropertyInclusionPolicy());
    }

    public InclusionPolicies with(RelationshipPropertyInclusionPolicy relationshipPropertyInclusionPolicy) {
        return new InclusionPolicies(this.getNodeInclusionPolicy(), this.getNodePropertyInclusionPolicy(), this.getRelationshipInclusionPolicy(), relationshipPropertyInclusionPolicy);
    }

    public NodeInclusionPolicy getNodeInclusionPolicy() {
        return this.nodeInclusionPolicy;
    }

    public NodePropertyInclusionPolicy getNodePropertyInclusionPolicy() {
        return this.nodePropertyInclusionPolicy;
    }

    public RelationshipInclusionPolicy getRelationshipInclusionPolicy() {
        return this.relationshipInclusionPolicy;
    }

    public RelationshipPropertyInclusionPolicy getRelationshipPropertyInclusionPolicy() {
        return this.relationshipPropertyInclusionPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InclusionPolicies that = (InclusionPolicies)o;
        if (!this.nodeInclusionPolicy.equals(that.nodeInclusionPolicy)) {
            return false;
        }
        if (!this.nodePropertyInclusionPolicy.equals(that.nodePropertyInclusionPolicy)) {
            return false;
        }
        if (!this.relationshipInclusionPolicy.equals(that.relationshipInclusionPolicy)) {
            return false;
        }
        return this.relationshipPropertyInclusionPolicy.equals(that.relationshipPropertyInclusionPolicy);
    }

    public int hashCode() {
        int result = this.nodeInclusionPolicy.hashCode();
        result = 31 * result + this.nodePropertyInclusionPolicy.hashCode();
        result = 31 * result + this.relationshipInclusionPolicy.hashCode();
        result = 31 * result + this.relationshipPropertyInclusionPolicy.hashCode();
        return result;
    }
}

