/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.policy.inclusion.composite;

import com.graphaware.common.policy.inclusion.BaseEntityInclusionPolicy;
import com.graphaware.common.policy.inclusion.EntityInclusionPolicy;
import java.util.Arrays;
import org.neo4j.graphdb.Entity;

public abstract class CompositeEntityInclusionPolicy<E extends Entity, T extends EntityInclusionPolicy<E>>
extends BaseEntityInclusionPolicy<E>
implements EntityInclusionPolicy<E> {
    protected final T[] policies;

    protected CompositeEntityInclusionPolicy(T[] policies) {
        if (policies == null || policies.length < 1) {
            throw new IllegalArgumentException("There must be at least one wrapped policy in composite policy");
        }
        this.policies = policies;
    }

    @Override
    public boolean include(E object) {
        for (E policy : this.policies) {
            if (policy.include(object)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeEntityInclusionPolicy that = (CompositeEntityInclusionPolicy)o;
        return Arrays.equals(this.policies, that.policies);
    }

    public int hashCode() {
        return Arrays.hashCode(this.policies);
    }
}

