/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.policy.inclusion.composite;

import com.graphaware.common.policy.inclusion.PropertyInclusionPolicy;
import java.util.Arrays;
import org.neo4j.graphdb.Entity;

public abstract class CompositePropertyInclusionPolicy<T extends Entity>
implements PropertyInclusionPolicy<T> {
    private final PropertyInclusionPolicy<T>[] policies;

    protected CompositePropertyInclusionPolicy(PropertyInclusionPolicy<T>[] policies) {
        if (policies == null || policies.length < 1) {
            throw new IllegalArgumentException("There must be at least one wrapped policy in composite policy");
        }
        for (PropertyInclusionPolicy<T> p : policies) {
            if (p != null) continue;
            throw new IllegalArgumentException("Policy must not be null");
        }
        this.policies = policies;
    }

    @Override
    public boolean include(String key, T object) {
        for (PropertyInclusionPolicy<T> policy : this.policies) {
            if (policy.include(key, object)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositePropertyInclusionPolicy that = (CompositePropertyInclusionPolicy)o;
        return Arrays.equals(this.policies, that.policies);
    }

    public int hashCode() {
        return Arrays.hashCode(this.policies);
    }
}

