/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.policy.inclusion.composite;

import com.graphaware.common.policy.inclusion.EntityInclusionPolicy;
import com.graphaware.common.policy.inclusion.RelationshipInclusionPolicy;
import com.graphaware.common.policy.inclusion.composite.CompositeEntityInclusionPolicy;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public final class CompositeRelationshipInclusionPolicy
extends CompositeEntityInclusionPolicy<Relationship, RelationshipInclusionPolicy>
implements RelationshipInclusionPolicy {
    public static CompositeRelationshipInclusionPolicy of(RelationshipInclusionPolicy ... policies) {
        return new CompositeRelationshipInclusionPolicy(policies);
    }

    private CompositeRelationshipInclusionPolicy(RelationshipInclusionPolicy[] policies) {
        super((EntityInclusionPolicy[])policies);
    }

    @Override
    public boolean include(Relationship relationship, Node pointOfView) {
        for (RelationshipInclusionPolicy policy : (RelationshipInclusionPolicy[])this.policies) {
            if (policy.include(relationship, pointOfView)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Iterable<Relationship> doGetAll(GraphDatabaseService database) {
        return database.getAllRelationships();
    }
}

