/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.policy.inclusion.fluent;

import com.graphaware.common.description.property.DetachedPropertiesDescription;
import com.graphaware.common.policy.inclusion.NodeInclusionPolicy;
import com.graphaware.common.policy.inclusion.fluent.IncludeEntities;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;

public abstract class BaseIncludeNodes<T extends BaseIncludeNodes<T>>
extends IncludeEntities<T, Node>
implements NodeInclusionPolicy {
    private final String label;

    public BaseIncludeNodes(String label, DetachedPropertiesDescription propertiesDescription) {
        super(propertiesDescription);
        this.label = label;
    }

    public T with(String label) {
        if (label == null) {
            return this.newInstance((String)null);
        }
        if (StringUtils.isEmpty((CharSequence)label)) {
            throw new IllegalArgumentException("Empty labels are not supported");
        }
        return this.newInstance(label);
    }

    public T with(Label label) {
        if (label == null) {
            return this.with((String)null);
        }
        return this.with(label.name());
    }

    protected abstract T newInstance(String var1);

    @Override
    public boolean include(Node node) {
        return (this.label == null || node.hasLabel(Label.label((String)this.label))) && super.include(node);
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseIncludeNodes that = (BaseIncludeNodes)o;
        return !(this.label != null ? !this.label.equals(that.label) : that.label != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        return result;
    }
}

