/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.policy.inclusion.fluent;

import com.graphaware.common.description.property.DetachedPropertiesDescription;
import com.graphaware.common.policy.inclusion.RelationshipInclusionPolicy;
import com.graphaware.common.policy.inclusion.fluent.IncludeEntities;
import com.graphaware.common.util.DirectionUtils;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public abstract class BaseIncludeRelationships<T extends BaseIncludeRelationships<T>>
extends IncludeEntities<T, Relationship>
implements RelationshipInclusionPolicy {
    private final Direction direction;
    private final String[] relationshipTypes;

    protected BaseIncludeRelationships(Direction direction, String[] relationshipTypes, DetachedPropertiesDescription propertiesDescription) {
        super(propertiesDescription);
        if (direction == null) {
            throw new IllegalArgumentException("Direction must not be null");
        }
        if (relationshipTypes == null) {
            throw new IllegalArgumentException("RelationshipTypes must not be null");
        }
        this.direction = direction;
        this.relationshipTypes = relationshipTypes;
    }

    public T with(String ... relationshipTypes) {
        return this.with(this.getDirection(), relationshipTypes);
    }

    public T with(RelationshipType ... relationshipTypes) {
        return this.with(this.getDirection(), relationshipTypes);
    }

    public T with(Direction direction) {
        return this.with(direction, this.getRelationshipTypes());
    }

    public T with(Direction direction, RelationshipType ... relationshipTypes) {
        return this.with(direction, this.typeToStrings(relationshipTypes));
    }

    public T with(Direction direction, String ... relationshipTypes) {
        if (direction == null) {
            throw new IllegalArgumentException("Direction must not be null");
        }
        if (relationshipTypes == null) {
            throw new IllegalArgumentException("RelationshipTypes must not be null");
        }
        for (String type : relationshipTypes) {
            if (!StringUtils.isEmpty((CharSequence)type)) continue;
            throw new IllegalArgumentException("Empty and null relationships types are not supported");
        }
        return this.newInstance(direction, relationshipTypes);
    }

    protected abstract T newInstance(Direction var1, String ... var2);

    @Override
    public boolean include(Relationship relationship) {
        if (this.relationshipTypes == null || this.relationshipTypes.length == 0) {
            return super.include(relationship);
        }
        for (String type : this.relationshipTypes) {
            if (!relationship.isType(RelationshipType.withName((String)type))) continue;
            return super.include(relationship);
        }
        return false;
    }

    @Override
    public boolean include(Relationship relationship, Node pointOfView) {
        return this.include(relationship) && DirectionUtils.matches(this.direction, DirectionUtils.resolveDirection(relationship, pointOfView));
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String[] getRelationshipTypes() {
        return this.relationshipTypes;
    }

    private String[] typeToStrings(RelationshipType[] relationshipTypes) {
        LinkedList<String> types = new LinkedList<String>();
        for (RelationshipType type : relationshipTypes) {
            if (type == null) {
                throw new IllegalArgumentException("Relationship Type must not be null");
            }
            types.add(type.name());
        }
        return types.toArray(new String[types.size()]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseIncludeRelationships that = (BaseIncludeRelationships)o;
        if (this.direction != that.direction) {
            return false;
        }
        return Arrays.equals(this.relationshipTypes, that.relationshipTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + Arrays.hashCode(this.relationshipTypes);
        return result;
    }
}

