/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.policy.inclusion.spel;

import com.graphaware.common.policy.inclusion.NodeInclusionPolicy;
import com.graphaware.common.policy.inclusion.spel.SpelInclusionPolicy;
import com.graphaware.common.representation.AttachedNode;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.FilteringIterable;

public class SpelNodeInclusionPolicy
extends SpelInclusionPolicy
implements NodeInclusionPolicy {
    public SpelNodeInclusionPolicy(String expression) {
        super(expression);
    }

    @Override
    public boolean include(Node node) {
        return (Boolean)this.exp.getValue((Object)new AttachedNode(node));
    }

    @Override
    public Iterable<Node> getAll(GraphDatabaseService database) {
        if (this.expressionNode.toStringAST().startsWith("hasLabel")) {
            String labelName = this.stripWrappingQuotes(this.expressionNode.getChild(0).toStringAST());
            return () -> database.findNodes(Label.label((String)labelName));
        }
        return new FilteringIterable((Iterable)database.getAllNodes(), this::include);
    }

    private String stripWrappingQuotes(String s) {
        if (s.startsWith("\"") || s.startsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

