/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.representation;

import com.graphaware.common.expression.EntityExpressions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.springframework.util.Assert;

public abstract class DetachedEntity<ID, T extends Entity>
implements Serializable,
EntityExpressions {
    public static final long NEW = -1L;
    private long graphId = -1L;
    private Map<String, Object> properties;

    protected DetachedEntity() {
    }

    protected abstract ID getId();

    protected DetachedEntity(T entity, String[] properties) {
        this(entity.getId());
        if (properties != null) {
            for (String property : properties) {
                if (!entity.hasProperty(property)) continue;
                this.putProperty(property, entity.getProperty(property));
            }
        } else {
            for (String property : entity.getPropertyKeys()) {
                this.putProperty(property, entity.getProperty(property));
            }
        }
    }

    protected DetachedEntity(long graphId) {
        this.graphId = graphId;
    }

    protected DetachedEntity(Map<String, Object> properties) {
        Assert.notNull(properties, (String)"Properties must not be null");
        this.setProperties(properties);
    }

    protected DetachedEntity(long graphId, Map<String, Object> properties) {
        Assert.notNull(properties, (String)"Properties must not be null");
        this.graphId = graphId;
        this.setProperties(properties);
    }

    public void putProperty(String key, Object value) {
        this.initPropsIfNeeded();
        this.properties.put(key, value);
    }

    private void initPropsIfNeeded() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
    }

    public T produceEntity(GraphDatabaseService database) {
        T result;
        try (Transaction tx = database.beginTx();){
            if (this.getGraphId() == -1L) {
                this.checkCanCreate();
                result = this.create(database);
                this.populate(result);
            } else {
                this.checkCanFetch();
                result = this.fetch(database);
            }
            tx.success();
        }
        return result;
    }

    protected abstract T create(GraphDatabaseService var1);

    protected abstract T fetch(GraphDatabaseService var1);

    protected void populate(T t) {
        this.setGraphId(t.getId());
        if (this.properties != null) {
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                t.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void checkCanCreate() {
    }

    protected void checkCanFetch() {
        if (this.getProperties() != null) {
            throw new IllegalStateException("Must not specify properties for existing entity!");
        }
    }

    public long getGraphId() {
        return this.graphId;
    }

    public void setGraphId(long graphId) {
        this.graphId = graphId;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        Assert.notNull(properties, (String)"Properties must not be null");
        this.initPropsIfNeeded();
        this.properties.putAll(properties);
    }

    protected String[] propertyKeySetAsStringArray(Iterable<String> keySet) {
        ArrayList<String> keysAsList = new ArrayList<String>();
        for (String k : keySet) {
            keysAsList.add(k);
        }
        return keysAsList.toArray(new String[keysAsList.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetachedEntity that = (DetachedEntity)o;
        if (this.graphId != that.graphId) {
            return false;
        }
        return !(this.properties == null ? that.properties != null : !this.properties.equals(that.properties));
    }

    public int hashCode() {
        int result = (int)(this.graphId ^ this.graphId >>> 32);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

