/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.representation;

import com.graphaware.common.expression.DetachedNodeExpressions;
import com.graphaware.common.representation.DetachedEntity;
import java.util.Arrays;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.Iterables;
import org.springframework.util.Assert;

public abstract class DetachedNode<ID>
extends DetachedEntity<ID, Node>
implements DetachedNodeExpressions {
    private String[] labels;

    protected DetachedNode() {
    }

    protected DetachedNode(Node node) {
        this(node, (String[])null);
    }

    protected DetachedNode(Node node, String[] properties) {
        super(node, properties);
        this.setLabels((String[])Iterables.asArray(String.class, (Iterable)Iterables.map(Label::name, (Iterable)node.getLabels())));
    }

    protected DetachedNode(long graphId) {
        super(graphId);
    }

    protected DetachedNode(String[] labels, Map<String, Object> properties) {
        super(properties);
        Assert.notNull((Object)labels);
        this.labels = labels;
    }

    protected DetachedNode(long graphId, String[] labels, Map<String, Object> properties) {
        super(graphId, properties);
        Assert.notNull((Object)labels);
        this.labels = labels;
    }

    @Override
    protected Node create(GraphDatabaseService database) {
        return database.createNode();
    }

    @Override
    protected Node fetch(GraphDatabaseService database) {
        return database.getNodeById(this.getGraphId());
    }

    @Override
    protected void populate(Node node) {
        super.populate(node);
        if (this.labels != null) {
            for (String label : this.labels) {
                node.addLabel(Label.label((String)label));
            }
        }
    }

    @Override
    protected void checkCanFetch() {
        super.checkCanFetch();
        if (this.labels != null && this.labels.length != 0) {
            throw new IllegalStateException("Must not specify labels for existing node!");
        }
    }

    @Override
    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] labels) {
        Assert.notNull((Object)labels);
        this.labels = labels;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DetachedNode that = (DetachedNode)o;
        return Arrays.equals(this.labels, that.labels);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.labels);
        return result;
    }
}

