/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.representation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.graphaware.common.expression.DetachedRelationshipExpressions;
import com.graphaware.common.representation.DetachedEntity;
import com.graphaware.common.representation.DetachedNode;
import com.graphaware.common.transform.NodeIdTransformer;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.util.Assert;

public abstract class DetachedRelationship<ID, N extends DetachedNode<ID>>
extends DetachedEntity<ID, Relationship>
implements DetachedRelationshipExpressions {
    private long startNodeGraphId = -1L;
    private long endNodeGraphId = -1L;
    private N startNode;
    private N endNode;
    private String type;

    protected DetachedRelationship() {
    }

    protected DetachedRelationship(Relationship relationship, NodeIdTransformer<ID> nodeIdTransformer) {
        this(relationship, null, nodeIdTransformer);
        this.startNode = this.startNode(relationship, nodeIdTransformer);
        this.endNode = this.endNode(relationship, nodeIdTransformer);
    }

    protected DetachedRelationship(Relationship relationship, String[] properties, NodeIdTransformer<ID> nodeIdTransformer) {
        super(relationship, properties);
        this.startNodeGraphId = relationship.getStartNode().getId();
        this.endNodeGraphId = relationship.getEndNode().getId();
        this.setType(relationship.getType().name());
        this.startNode = this.startNode(relationship, nodeIdTransformer);
        this.endNode = this.endNode(relationship, nodeIdTransformer);
    }

    protected DetachedRelationship(long graphId) {
        super(graphId);
    }

    protected DetachedRelationship(long startNodeGraphId, long endNodeGraphId, String type, Map<String, Object> properties) {
        super(properties);
        Assert.hasLength((String)type);
        this.startNodeGraphId = startNodeGraphId;
        this.endNodeGraphId = endNodeGraphId;
        this.type = type;
    }

    protected DetachedRelationship(long graphId, long startNodeGraphId, long endNodeGraphId, String type, Map<String, Object> properties) {
        super(graphId, properties);
        Assert.hasLength((String)type);
        this.startNodeGraphId = startNodeGraphId;
        this.endNodeGraphId = endNodeGraphId;
        this.type = type;
    }

    @Override
    protected Relationship create(GraphDatabaseService database) {
        return database.getNodeById(this.startNodeGraphId).createRelationshipTo(database.getNodeById(this.endNodeGraphId), RelationshipType.withName((String)this.type));
    }

    @Override
    protected Relationship fetch(GraphDatabaseService database) {
        return database.getRelationshipById(this.getGraphId());
    }

    @Override
    protected void checkCanCreate() {
        super.checkCanCreate();
        if (this.type == null || this.type.length() == 0) {
            throw new IllegalStateException("Relationship type must not be null or empty");
        }
        if (this.startNodeGraphId == -1L || this.endNodeGraphId == -1L) {
            throw new IllegalStateException("Start and End node IDs must be specified");
        }
    }

    @Override
    protected void checkCanFetch() {
        super.checkCanFetch();
        if (this.startNodeGraphId != -1L || this.endNodeGraphId != -1L) {
            throw new IllegalStateException("Must not specify start/end node for existing relationship!");
        }
        if (this.type != null) {
            throw new IllegalStateException("Must not specify type for existing relationship!");
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        Assert.hasLength((String)type);
        this.type = type;
    }

    public long getStartNodeGraphId() {
        return this.startNodeGraphId;
    }

    public void setStartNodeGraphId(long startNodeGraphId) {
        this.startNodeGraphId = startNodeGraphId;
    }

    public long getEndNodeGraphId() {
        return this.endNodeGraphId;
    }

    public void setEndNodeGraphId(long endNodeGraphId) {
        this.endNodeGraphId = endNodeGraphId;
    }

    @JsonIgnore
    public DetachedNode getStartNode() {
        return this.startNode;
    }

    @JsonIgnore
    public DetachedNode getEndNode() {
        return this.endNode;
    }

    protected abstract N startNode(Relationship var1, NodeIdTransformer<ID> var2);

    protected abstract N endNode(Relationship var1, NodeIdTransformer<ID> var2);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DetachedRelationship that = (DetachedRelationship)o;
        if (this.startNodeGraphId != that.startNodeGraphId) {
            return false;
        }
        if (this.endNodeGraphId != that.endNodeGraphId) {
            return false;
        }
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.startNodeGraphId ^ this.startNodeGraphId >>> 32);
        result = 31 * result + (int)(this.endNodeGraphId ^ this.endNodeGraphId >>> 32);
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

