/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.graphaware.common.description.predicate.Predicates;
import com.graphaware.common.description.property.LiteralPropertiesDescription;
import com.graphaware.common.description.relationship.DetachedRelationshipDescriptionImpl;
import com.graphaware.common.policy.inclusion.all.IncludeAllNodeProperties;
import com.graphaware.common.policy.inclusion.all.IncludeAllNodes;
import com.graphaware.common.policy.inclusion.all.IncludeAllRelationshipProperties;
import com.graphaware.common.policy.inclusion.all.IncludeAllRelationships;
import com.graphaware.common.policy.inclusion.none.IncludeNoNodeProperties;
import com.graphaware.common.policy.inclusion.none.IncludeNoNodes;
import com.graphaware.common.policy.inclusion.none.IncludeNoRelationshipProperties;
import com.graphaware.common.policy.inclusion.none.IncludeNoRelationships;
import com.graphaware.common.policy.role.AnyRole;
import com.graphaware.common.policy.role.MasterOnly;
import com.graphaware.common.policy.role.SlavesOnly;
import com.graphaware.common.policy.role.WritableRole;
import com.graphaware.common.serialize.SingletonSerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.neo4j.graphdb.Direction;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public final class Serializer {
    private static Kryo kryo = new Kryo();

    private Serializer() {
    }

    public static synchronized void register(Class type) {
        kryo.register(type);
    }

    public static synchronized void register(Class type, com.esotericsoftware.kryo.Serializer serializer) {
        kryo.register(type, serializer);
    }

    public static synchronized void register(Class type, com.esotericsoftware.kryo.Serializer serializer, int id) {
        kryo.register(type, serializer, id);
    }

    public static synchronized byte[] toByteArray(Object object) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)stream);
        kryo.writeClassAndObject(output, object);
        output.flush();
        output.close();
        return stream.toByteArray();
    }

    public static synchronized String toString(Object object, String prefix) {
        return prefix + new String(Base64.encodeBase64((byte[])Serializer.toByteArray(object)));
    }

    public static synchronized <T> T fromByteArray(byte[] array) {
        return (T)kryo.readClassAndObject(new Input(array));
    }

    public static synchronized <T> T fromString(String string, String prefix) {
        return Serializer.fromByteArray(Base64.decodeBase64((String)string.substring(prefix.length())));
    }

    static {
        kryo.setRegistrationRequired(false);
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        kryo.register(Direction.class, 11);
        kryo.register(HashMap.class, 15);
        kryo.register(TreeMap.class, 16);
        Predicates.register(kryo);
        kryo.register(LiteralPropertiesDescription.class, 31);
        kryo.register(DetachedRelationshipDescriptionImpl.class, 41);
        kryo.register(byte[].class, 100);
        kryo.register(char[].class, 101);
        kryo.register(boolean[].class, 102);
        kryo.register(long[].class, 103);
        kryo.register(double[].class, 104);
        kryo.register(int[].class, 105);
        kryo.register(short[].class, 106);
        kryo.register(float[].class, 107);
        kryo.register(String[].class, 108);
        Serializer.register(IncludeAllNodeProperties.class, new SingletonSerializer());
        Serializer.register(IncludeAllNodes.class, new SingletonSerializer());
        Serializer.register(IncludeAllRelationshipProperties.class, new SingletonSerializer());
        Serializer.register(IncludeAllRelationships.class, new SingletonSerializer());
        Serializer.register(IncludeNoNodeProperties.class, new SingletonSerializer());
        Serializer.register(IncludeNoNodes.class, new SingletonSerializer());
        Serializer.register(IncludeNoRelationshipProperties.class, new SingletonSerializer());
        Serializer.register(IncludeNoRelationships.class, new SingletonSerializer());
        Serializer.register(AnyRole.class, new SingletonSerializer());
        Serializer.register(MasterOnly.class, new SingletonSerializer());
        Serializer.register(SlavesOnly.class, new SingletonSerializer());
        Serializer.register(WritableRole.class, new SingletonSerializer());
    }
}

