/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.stopwatch;

import com.graphaware.common.stopwatch.Event;
import java.util.HashMap;

public class Stopwatch {
    private HashMap<String, Event> events = new HashMap();

    public void start(String eventName) {
        this.startEvent(eventName);
    }

    public Event stop(String eventName) {
        return this.stopEvent(eventName);
    }

    public void lap(String eventName) {
        this.ensureEventExists(eventName);
        this.events.get(eventName).addPeriod();
    }

    private void startEvent(String eventName) {
        if (this.events.containsKey(eventName)) {
            throw new IllegalArgumentException("An event with name " + eventName + " was already started");
        }
        this.events.put(eventName, new Event());
    }

    private Event stopEvent(String eventName) {
        this.ensureEventExists(eventName);
        this.events.get(eventName).stop();
        return this.events.get(eventName);
    }

    private void ensureEventExists(String eventName) {
        if (!this.events.containsKey(eventName)) {
            throw new IllegalArgumentException("No event with name " + eventName + " has been started");
        }
    }
}

