/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.util;

import java.util.Arrays;
import java.util.Map;

public final class ArrayUtils {
    public static boolean isPrimitiveArray(Object o) {
        if (o instanceof byte[]) {
            return true;
        }
        if (o instanceof char[]) {
            return true;
        }
        if (o instanceof boolean[]) {
            return true;
        }
        if (o instanceof long[]) {
            return true;
        }
        if (o instanceof double[]) {
            return true;
        }
        if (o instanceof int[]) {
            return true;
        }
        if (o instanceof short[]) {
            return true;
        }
        return o instanceof float[];
    }

    public static boolean isPrimitiveOrStringArray(Object o) {
        if (ArrayUtils.isPrimitiveArray(o)) {
            return true;
        }
        return o instanceof String[];
    }

    public static boolean isArray(Object o) {
        if (ArrayUtils.isPrimitiveArray(o)) {
            return true;
        }
        return o instanceof Object[];
    }

    public static boolean arrayFriendlyEquals(Object o1, Object o2) {
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        return o1.equals(o2);
    }

    public static int arrayFriendlyHashCode(Object o) {
        if (o instanceof byte[]) {
            return Arrays.hashCode((byte[])o);
        }
        if (o instanceof char[]) {
            return Arrays.hashCode((char[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.hashCode((boolean[])o);
        }
        if (o instanceof long[]) {
            return Arrays.hashCode((long[])o);
        }
        if (o instanceof double[]) {
            return Arrays.hashCode((double[])o);
        }
        if (o instanceof int[]) {
            return Arrays.hashCode((int[])o);
        }
        if (o instanceof short[]) {
            return Arrays.hashCode((short[])o);
        }
        if (o instanceof float[]) {
            return Arrays.hashCode((float[])o);
        }
        if (o instanceof Object[]) {
            return Arrays.hashCode((Object[])o);
        }
        return o.hashCode();
    }

    public static String primitiveOrStringArrayToString(Object o) {
        if (o instanceof byte[]) {
            return Arrays.toString((byte[])o);
        }
        if (o instanceof char[]) {
            return Arrays.toString((char[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.toString((boolean[])o);
        }
        if (o instanceof long[]) {
            return Arrays.toString((long[])o);
        }
        if (o instanceof double[]) {
            return Arrays.toString((double[])o);
        }
        if (o instanceof int[]) {
            return Arrays.toString((int[])o);
        }
        if (o instanceof short[]) {
            return Arrays.toString((short[])o);
        }
        if (o instanceof float[]) {
            return Arrays.toString((float[])o);
        }
        if (o instanceof String[]) {
            return Arrays.toString((String[])o);
        }
        throw new IllegalArgumentException("Object must be a primitive array!");
    }

    public static <T> boolean arrayFriendlyMapEquals(Map<String, T> map1, Map<String, T> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        try {
            for (Map.Entry<String, T> e : map1.entrySet()) {
                String key = e.getKey();
                T value = e.getValue();
                if (!(value == null ? map2.get(key) != null || !map2.containsKey(key) : !ArrayUtils.arrayFriendlyEquals(value, map2.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    private ArrayUtils() {
    }
}

