/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.util;

import com.graphaware.common.util.ComparableItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BoundedSortedList<T, C extends Comparable<C>> {
    private final List<ComparableItem<T, C>> items = new ArrayList<ComparableItem<T, C>>();
    private final Comparator<ComparableItem<T, C>> comparator;
    private final int capacity;
    private final int maxCapacity;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public BoundedSortedList(int capacity) {
        this(capacity, capacity);
    }

    public BoundedSortedList(int capacity, Comparator<C> comparator) {
        this(capacity, capacity, comparator);
    }

    public BoundedSortedList(int capacity, int maxCapacity) {
        this(capacity, maxCapacity, new Comparator<C>(){

            @Override
            public int compare(C o1, C o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public BoundedSortedList(int capacity, int maxCapacity, final Comparator<C> comparator) {
        this.comparator = new Comparator<ComparableItem<T, C>>(){

            @Override
            public int compare(ComparableItem<T, C> o1, ComparableItem<T, C> o2) {
                return comparator.compare(o1.getQuantity(), o2.getQuantity());
            }
        };
        this.capacity = capacity;
        this.maxCapacity = maxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getItems() {
        LinkedList<T> result = new LinkedList<T>();
        this.lock.readLock().lock();
        try {
            for (ComparableItem<T, C> comparableItem : this.items) {
                result.add(comparableItem.getItem());
                if (result.size() < this.capacity) continue;
                break;
            }
            LinkedList<T> linkedList = result;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T item, C quantity) {
        ComparableItem<T, C> comparableItem = new ComparableItem<T, C>(item, quantity);
        this.lock.readLock().lock();
        try {
            if (!this.items.contains(comparableItem) && this.items.size() >= this.maxCapacity && this.comparator.compare(this.items.get(this.items.size() - 1), comparableItem) < 0) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.items.contains(comparableItem)) {
                this.items.remove(comparableItem);
            }
            this.items.add(comparableItem);
            Collections.sort(this.items, this.comparator);
            while (this.items.size() > this.maxCapacity) {
                this.items.remove(this.items.size() - 1);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

