/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Entity;

public class Change<T> {
    private final T previous;
    private final T current;

    public Change(T previous, T current) {
        this.previous = previous;
        this.current = current;
    }

    public T getPrevious() {
        return this.previous;
    }

    public T getCurrent() {
        return this.current;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Change change = (Change)o;
        if (!this.current.equals(change.current)) {
            return false;
        }
        return this.previous.equals(change.previous);
    }

    public int hashCode() {
        int result = this.previous.hashCode();
        result = 31 * result + this.current.hashCode();
        return result;
    }

    public static <T extends Entity> Map<Long, Change<T>> changesToMap(Collection<Change<T>> changes) {
        HashMap<Long, Change<T>> result = new HashMap<Long, Change<T>>();
        for (Change<T> change : changes) {
            long id = ((Entity)change.getPrevious()).getId();
            if (id != ((Entity)change.getCurrent()).getId()) {
                throw new IllegalArgumentException("IDs of the Entities in Change do not match!");
            }
            result.put(id, change);
        }
        return result;
    }
}

