/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.util;

import org.springframework.util.Assert;

public class ComparableItem<T, C extends Comparable<C>>
implements Comparable<ComparableItem<T, C>> {
    private final T item;
    private final C quantity;

    public ComparableItem(T item, C quantity) {
        Assert.notNull(item);
        Assert.notNull(quantity);
        this.item = item;
        this.quantity = quantity;
    }

    public T getItem() {
        return this.item;
    }

    public C getQuantity() {
        return this.quantity;
    }

    @Override
    public int compareTo(ComparableItem<T, C> o) {
        return this.getQuantity().compareTo(o.getQuantity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableItem that = (ComparableItem)o;
        return this.item.equals(that.item);
    }

    public int hashCode() {
        return this.item.hashCode();
    }
}

