/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.util;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.neo4j.graphdb.GraphDatabaseService;

public final class DatabaseUtils {
    private static Set<GraphDatabaseService> databases = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));

    public static void registerShutdownHook(GraphDatabaseService database) {
        databases.add(database);
    }

    private DatabaseUtils() {
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (GraphDatabaseService database : databases) {
                    database.shutdown();
                }
            }
        });
    }
}

