/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.util;

import com.graphaware.common.expression.AttachedNodeExpressions;
import com.graphaware.common.expression.AttachedRelationshipExpressions;
import com.graphaware.common.log.LoggerFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.logging.Log;

public final class DirectionUtils {
    private static final Log LOG = LoggerFactory.getLogger(DirectionUtils.class);

    public static Direction resolveDirection(Relationship relationship, Node pointOfView) {
        return DirectionUtils.resolveDirection(relationship, pointOfView, Direction.BOTH);
    }

    public static Direction resolveDirection(Relationship relationship, Node pointOfView, Direction defaultDirection) {
        if (relationship.getEndNode().getId() != pointOfView.getId() && relationship.getStartNode().getId() != pointOfView.getId()) {
            String message = "Provided relationship (" + relationship.getId() + ") does not have node (" + pointOfView.getId() + ") on either of its ends!";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (relationship.getEndNode().getId() == relationship.getStartNode().getId()) {
            return defaultDirection;
        }
        return relationship.getStartNode().getId() == pointOfView.getId() ? Direction.OUTGOING : Direction.INCOMING;
    }

    public static Direction resolveDirection(AttachedRelationshipExpressions<?> relationship, AttachedNodeExpressions pointOfView, Direction defaultDirection) {
        if (!relationship.getEndNode().equals(pointOfView) && !relationship.getStartNode().equals(pointOfView)) {
            String message = "Provided relationship (" + relationship + ") does not have node (" + pointOfView + ") on either of its ends!";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (relationship.getEndNode().equals(relationship.getStartNode())) {
            return defaultDirection;
        }
        return relationship.getStartNode().equals(pointOfView) ? Direction.OUTGOING : Direction.INCOMING;
    }

    public static boolean matches(Relationship relationship, Node pointOfView, Direction direction) {
        return DirectionUtils.matches(direction, DirectionUtils.resolveDirection(relationship, pointOfView, Direction.BOTH));
    }

    public static boolean matches(Direction direction1, Direction direction2) {
        return Direction.BOTH.equals((Object)direction1) || Direction.BOTH.equals((Object)direction2) || direction1.equals((Object)direction2);
    }

    public static Direction reverse(Direction direction) {
        switch (direction) {
            case BOTH: {
                return Direction.BOTH;
            }
            case OUTGOING: {
                return Direction.INCOMING;
            }
            case INCOMING: {
                return Direction.OUTGOING;
            }
        }
        throw new IllegalArgumentException("Unknown direction " + direction);
    }

    private DirectionUtils() {
    }
}

