/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.util;

import com.graphaware.common.policy.inclusion.ObjectInclusionPolicy;
import com.graphaware.common.policy.inclusion.all.IncludeAll;
import com.graphaware.common.util.ArrayUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public final class EntityUtils {
    public static <T extends Entity> Map<Long, T> entitiesToMap(Collection<T> entities) {
        HashMap<Long, Entity> result = new HashMap<Long, Entity>();
        for (Entity entity : entities) {
            result.put(entity.getId(), entity);
        }
        return result;
    }

    public static Long[] ids(Iterable<? extends Entity> entities) {
        LinkedList<Long> result = new LinkedList<Long>();
        for (Entity entity : entities) {
            result.add(entity.getId());
        }
        return result.toArray(new Long[result.size()]);
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return "";
        }
        if (ArrayUtils.isPrimitiveOrStringArray(value)) {
            return ArrayUtils.primitiveOrStringArrayToString(value);
        }
        return String.valueOf(value);
    }

    public static Map<String, Object> propertiesToMap(Entity Entity2) {
        return EntityUtils.propertiesToMap(Entity2, new IncludeAll<String>());
    }

    public static Map<String, Object> propertiesToMap(Entity Entity2, ObjectInclusionPolicy<String> propertyInclusionPolicy) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : Entity2.getPropertyKeys()) {
            if (!propertyInclusionPolicy.include(key)) continue;
            result.put(key, Entity2.getProperty(key));
        }
        return result;
    }

    public static int deleteNodeAndRelationships(Node toDelete) {
        int result = 0;
        for (Relationship relationship : toDelete.getRelationships()) {
            relationship.delete();
            ++result;
        }
        toDelete.delete();
        return result;
    }

    public static String nodeToString(Node node) {
        StringBuilder string = new StringBuilder("(");
        LinkedList<String> labelNames = new LinkedList<String>();
        for (Label label : node.getLabels()) {
            labelNames.add(label.name());
        }
        Collections.sort(labelNames);
        for (String labelName : labelNames) {
            string.append(":").append(labelName);
        }
        String props = EntityUtils.propertiesToString((Entity)node);
        if (StringUtils.isNotEmpty((CharSequence)props) && !labelNames.isEmpty()) {
            string.append(" ");
        }
        string.append(props);
        string.append(")");
        return string.toString();
    }

    public static String relationshipToString(Relationship relationship) {
        StringBuilder string = new StringBuilder();
        string.append(EntityUtils.nodeToString(relationship.getStartNode()));
        string.append("-[:").append(relationship.getType().name());
        String props = EntityUtils.propertiesToString((Entity)relationship);
        if (StringUtils.isNotEmpty((CharSequence)props)) {
            string.append(" ");
        }
        string.append(props);
        string.append("]->");
        string.append(EntityUtils.nodeToString(relationship.getEndNode()));
        return string.toString();
    }

    public static String propertiesToString(Entity Entity2) {
        if (!Entity2.getPropertyKeys().iterator().hasNext()) {
            return "";
        }
        StringBuilder string = new StringBuilder("{");
        LinkedList<String> propertyKeys = new LinkedList<String>();
        for (String key : Entity2.getPropertyKeys()) {
            propertyKeys.add(key);
        }
        Collections.sort(propertyKeys);
        boolean first = true;
        for (String key : propertyKeys) {
            if (!first) {
                string.append(", ");
            }
            first = false;
            string.append(key).append(": ").append(EntityUtils.valueToString(Entity2.getProperty(key)));
        }
        string.append("}");
        return string.toString();
    }

    public static int getInt(Entity Entity2, String key) {
        return EntityUtils.getInt(Entity2.toString(), key, Entity2.getProperty(key));
    }

    public static int getInt(Entity Entity2, String key, int defaultValue) {
        return EntityUtils.getInt(Entity2.toString(), key, Entity2.getProperty(key, (Object)defaultValue));
    }

    public static long getLong(Entity Entity2, String key) {
        return EntityUtils.getLong(Entity2.toString(), key, Entity2.getProperty(key));
    }

    public static long getLong(Entity Entity2, String key, long defaultValue) {
        return EntityUtils.getLong(Entity2.toString(), key, Entity2.getProperty(key, (Object)defaultValue));
    }

    public static float getFloat(Entity Entity2, String key) {
        return EntityUtils.getFloat(Entity2.toString(), key, Entity2.getProperty(key));
    }

    public static float getFloat(Entity Entity2, String key, float defaultValue) {
        return EntityUtils.getFloat(Entity2.toString(), key, Entity2.getProperty(key, (Object)Float.valueOf(defaultValue)));
    }

    private static int getInt(String entity, String key, Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        throw new ClassCastException(value + " is not a number! (" + entity + ", key=" + key + ")");
    }

    private static long getLong(String entity, String key, Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new ClassCastException(value + " is not a number! (" + entity + ", key=" + key + ")");
    }

    private static float getFloat(String entity, String key, Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).floatValue();
        }
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).floatValue();
        }
        if (value instanceof Long) {
            return ((Long)value).floatValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        throw new ClassCastException(value + " is not a number! (" + entity + ", key=" + key + ")");
    }

    private EntityUtils() {
    }
}

