/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.util;

import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class RelationshipUtils {
    public static Relationship getSingleRelationship(Node node1, Node node2, RelationshipType type, Direction direction) {
        Relationship result = RelationshipUtils.getSingleRelationshipOrNull(node1, node2, type, direction);
        if (result == null) {
            throw new NotFoundException("Relationship between " + node1 + " and " + node2 + " of type " + type + " and direction " + direction + " does not exist.");
        }
        return result;
    }

    public static Relationship getSingleRelationshipOrNull(Node node1, Node node2, RelationshipType type, Direction direction) {
        Path singlePath = GraphAlgoFactory.shortestPath((PathExpander)PathExpanders.forTypeAndDirection((RelationshipType)type, (Direction)direction), (int)1, (int)1).findSinglePath(node1, node2);
        if (singlePath == null) {
            return null;
        }
        return singlePath.lastRelationship();
    }

    public static boolean relationshipNotExists(Node node1, Node node2, RelationshipType type, Direction direction) {
        return !RelationshipUtils.relationshipExists(node1, node2, type, direction);
    }

    public static boolean relationshipExists(Node node1, Node node2, RelationshipType type, Direction direction) {
        return RelationshipUtils.getSingleRelationshipOrNull(node1, node2, type, direction) != null;
    }

    public static void deleteRelationshipIfExists(Node node1, Node node2, RelationshipType type, Direction direction) {
        Relationship r = RelationshipUtils.getSingleRelationshipOrNull(node1, node2, type, direction);
        if (r != null) {
            r.delete();
        }
    }

    public static Relationship createRelationshipIfNotExists(Node node1, Node node2, RelationshipType type, Direction direction) {
        Relationship existing = RelationshipUtils.getSingleRelationshipOrNull(node1, node2, type, direction);
        if (existing == null) {
            if (Direction.INCOMING.equals((Object)direction)) {
                return node2.createRelationshipTo(node1, type);
            }
            return node1.createRelationshipTo(node2, type);
        }
        return existing;
    }

    private RelationshipUtils() {
    }
}

