/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.util;

import java.util.Random;
import java.util.Vector;

public class ReservoirSampler<T> {
    private final Vector<T> reservoir = new Vector();
    private final int numberOfSamples;
    private final Random random = new Random();
    private int numberOfItemsSeen = 0;

    public ReservoirSampler(int numberOfSamples) {
        if (numberOfSamples <= 0) {
            throw new IllegalArgumentException("Reservoir must be bigger than 0");
        }
        this.numberOfSamples = numberOfSamples;
    }

    public void sample(T item) {
        if (item == null) {
            throw new IllegalArgumentException("Item to random must not be null");
        }
        if (this.reservoir.size() < this.numberOfSamples) {
            this.reservoir.add(item);
        } else {
            int index = this.random.nextInt(this.numberOfItemsSeen + 1);
            if (index < this.numberOfSamples) {
                this.reservoir.set(index, item);
            }
        }
        ++this.numberOfItemsSeen;
    }

    public Iterable<T> getSamples() {
        return this.reservoir;
    }

    public boolean isEmpty() {
        return this.reservoir.isEmpty();
    }
}

