/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.wrapper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public abstract class BaseEntity
implements Entity {
    public Object getProperty(String key, Object defaultValue) {
        if (!this.hasProperty(key)) {
            return defaultValue;
        }
        return this.getProperty(key);
    }

    public Map<String, Object> getAllProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.getPropertyKeys()) {
            result.put(key, this.getProperty(key));
        }
        return result;
    }

    public Map<String, Object> getProperties(String ... keys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : keys) {
            if (!this.hasProperty(key)) continue;
            result.put(key, this.getProperty(key));
        }
        return result;
    }

    public Node getOtherNode(Node node) {
        Relationship self = this.relationship();
        Node startNode = self.getStartNode();
        Node endNode = self.getEndNode();
        if (node.getId() == startNode.getId()) {
            return endNode;
        }
        if (node.getId() == endNode.getId()) {
            return startNode;
        }
        throw new IllegalArgumentException("Node with ID " + node.getId() + " does not participate in relationship ID " + self.getId());
    }

    public Node[] getNodes() {
        Relationship self = this.relationship();
        return new Node[]{self.getStartNode(), self.getEndNode()};
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        Node self = this.node();
        Iterator iterator = self.getRelationships(type, dir).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Relationship toReturn = (Relationship)iterator.next();
        if (iterator.hasNext()) {
            throw new NotFoundException("More than one relationship[" + type + ", " + dir + "] found for " + self);
        }
        return toReturn;
    }

    public boolean hasRelationship() {
        return this.node().getRelationships().iterator().hasNext();
    }

    public boolean hasRelationship(RelationshipType ... types) {
        return this.node().getRelationships(types).iterator().hasNext();
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        return this.node().getRelationships(direction, types).iterator().hasNext();
    }

    public boolean hasRelationship(Direction dir) {
        return this.node().getRelationships(dir).iterator().hasNext();
    }

    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.node().getRelationships(type, dir).iterator().hasNext();
    }

    public boolean isType(RelationshipType type) {
        return this.relationship().getType().name().equals(type.name());
    }

    protected Node node() {
        if (!(this instanceof Node)) {
            throw new IllegalStateException("Not a node, this is a bug");
        }
        return (Node)this;
    }

    protected Relationship relationship() {
        if (!(this instanceof Relationship)) {
            throw new IllegalStateException("Not a relationship, this is a bug");
        }
        return (Relationship)this;
    }
}

