/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.common.wrapper;

import com.graphaware.common.wrapper.BaseEntity;
import com.graphaware.common.wrapper.EntityWrapper;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IterableWrapper;

public abstract class BaseEntityWrapper<T extends Entity>
extends BaseEntity
implements EntityWrapper<T> {
    protected abstract T self();

    public long getId() {
        return ((Entity)this.getWrapped()).getId();
    }

    public boolean hasProperty(String key) {
        return ((Entity)this.getWrapped()).hasProperty(key);
    }

    public Object getProperty(String key) {
        if (!this.hasProperty(key)) {
            throw new NotFoundException("Property " + key + " not present on " + this.self() + " or filtered out");
        }
        return ((Entity)this.getWrapped()).getProperty(key);
    }

    public void setProperty(String key, Object value) {
        ((Entity)this.getWrapped()).setProperty(key, value);
    }

    public Object removeProperty(String key) {
        return ((Entity)this.getWrapped()).removeProperty(key);
    }

    public Iterable<String> getPropertyKeys() {
        return ((Entity)this.getWrapped()).getPropertyKeys();
    }

    public Iterable<Relationship> getRelationships() {
        return this.getRelationships(Direction.BOTH);
    }

    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.getRelationships(Direction.BOTH, types);
    }

    public Iterable<Relationship> getRelationships(Direction dir) {
        return this.getRelationships(dir, new RelationshipType[0]);
    }

    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.getRelationships(dir, type);
    }

    public boolean hasLabel(Label label) {
        return this.getWrappedNode().hasLabel(label);
    }

    public Iterable<Label> getLabels() {
        return this.getWrappedNode().getLabels();
    }

    public void addLabel(Label label) {
        this.getWrappedNode().addLabel(label);
    }

    public void removeLabel(Label label) {
        this.getWrappedNode().removeLabel(label);
    }

    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        if (types == null || types.length == 0) {
            return this.wrapRelationships(this.getWrappedNode().getRelationships(direction), direction, new RelationshipType[0]);
        }
        return this.wrapRelationships(this.getWrappedNode().getRelationships(direction, types), direction, types);
    }

    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        return this.wrapRelationship(this.getWrappedNode().createRelationshipTo(otherNode, type));
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.getWrappedNode().getRelationshipTypes();
    }

    public int getDegree() {
        return this.getWrappedNode().getDegree();
    }

    public int getDegree(RelationshipType type) {
        return this.getWrappedNode().getDegree(type);
    }

    public int getDegree(Direction direction) {
        return this.getWrappedNode().getDegree(direction);
    }

    public int getDegree(RelationshipType type, Direction direction) {
        return this.getWrappedNode().getDegree(type, direction);
    }

    public RelationshipType getType() {
        return this.getWrappedRelationship().getType();
    }

    public Node getStartNode() {
        return this.wrapNode(this.getWrappedRelationship().getStartNode());
    }

    public Node getEndNode() {
        return this.wrapNode(this.getWrappedRelationship().getEndNode());
    }

    protected Node wrapNode(Node node) {
        return node;
    }

    protected Relationship wrapRelationship(Relationship relationship) {
        return relationship;
    }

    protected Iterable<Relationship> wrapRelationships(Iterable<Relationship> relationships, Direction direction, RelationshipType ... relationshipTypes) {
        return new IterableWrapper<Relationship, Relationship>(relationships){

            protected Relationship underlyingObjectToObject(Relationship object) {
                return BaseEntityWrapper.this.wrapRelationship(object);
            }
        };
    }

    public void delete() {
        if (this.getWrapped() instanceof Node) {
            this.getWrappedNode().delete();
            return;
        }
        if (this.getWrapped() instanceof Relationship) {
            this.getWrappedRelationship().delete();
            return;
        }
        throw new IllegalStateException(this + " is not a Node or Relationship");
    }

    public GraphDatabaseService getGraphDatabase() {
        return ((Entity)this.getWrapped()).getGraphDatabase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEntityWrapper that = (BaseEntityWrapper)o;
        return ((Entity)this.getWrapped()).equals(that.getWrapped());
    }

    public int hashCode() {
        return ((Entity)this.getWrapped()).hashCode();
    }

    private Node getWrappedNode() {
        this.checkIsNode();
        return (Node)this.getWrapped();
    }

    private Relationship getWrappedRelationship() {
        this.checkIsRelationship();
        return (Relationship)this.getWrapped();
    }

    private void checkIsNode() {
        if (!(this.getWrapped() instanceof Node)) {
            throw new IllegalStateException("Not a node, this is a bug");
        }
    }

    private void checkIsRelationship() {
        if (!(this.getWrapped() instanceof Relationship)) {
            throw new IllegalStateException("Not a relationship, this is a bug");
        }
    }
}

