/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime;

import com.graphaware.runtime.GraphAwareRuntime;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class RuntimeRegistry {
    private static final Map<String, GraphAwareRuntime> RUNTIMES = new HashMap<String, GraphAwareRuntime>();

    public static void registerRuntime(GraphDatabaseService database, GraphAwareRuntime runtime) {
        RUNTIMES.put(RuntimeRegistry.storeDir(database), runtime);
    }

    public static GraphAwareRuntime getRuntime(GraphDatabaseService database) {
        return RUNTIMES.get(RuntimeRegistry.storeDir(database));
    }

    public static GraphAwareRuntime getStartedRuntime(GraphDatabaseService database) {
        GraphAwareRuntime runtime = RuntimeRegistry.getRuntime(database);
        if (runtime == null) {
            throw new IllegalStateException("No GraphAware Runtime is registered with the given database");
        }
        runtime.waitUntilStarted();
        return runtime;
    }

    public static void removeRuntime(GraphDatabaseService database) {
        RUNTIMES.remove(RuntimeRegistry.storeDir(database));
    }

    public static void clear() {
        RUNTIMES.clear();
    }

    private static String storeDir(GraphDatabaseService database) {
        return ((GraphDatabaseAPI)database).databaseLayout().getStoreLayout().storeDirectory().getAbsolutePath();
    }
}

