/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.runtime.GraphAwareRuntime;
import com.graphaware.runtime.config.RuntimeConfiguration;
import com.graphaware.runtime.module.RuntimeModule;
import com.graphaware.tx.event.improved.api.ImprovedTransactionData;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.logging.Log;

public abstract class BaseGraphAwareRuntime
implements GraphAwareRuntime,
KernelEventHandler {
    private static final Log LOG = LoggerFactory.getLogger(BaseGraphAwareRuntime.class);
    private static final ThreadLocal<Boolean> startingThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final RuntimeConfiguration configuration;
    private volatile State state = State.NONE;

    protected BaseGraphAwareRuntime(RuntimeConfiguration configuration) {
        this.configuration = configuration;
        if (!State.NONE.equals((Object)this.state)) {
            throw new IllegalStateException("Only one instance of the GraphAware Runtime should ever be instantiated and started.");
        }
        this.state = State.REGISTERED;
    }

    public RuntimeConfiguration getConfiguration() {
        return this.configuration;
    }

    public final synchronized void registerModule(RuntimeModule module) {
        if (!State.REGISTERED.equals((Object)this.state)) {
            LOG.error("Modules must be registered before GraphAware Runtime is started!");
            throw new IllegalStateException("Modules must be registered before GraphAware Runtime is started!");
        }
        LOG.info("Registering module " + module.getId() + " with GraphAware Runtime.");
        this.checkNotAlreadyRegistered(module);
        this.doRegisterModule(module);
    }

    protected abstract void checkNotAlreadyRegistered(RuntimeModule var1);

    protected abstract void doRegisterModule(RuntimeModule var1);

    public final synchronized void start() {
        if (State.STARTED.equals((Object)this.state)) {
            LOG.debug("GraphAware already started");
            return;
        }
        if (State.STARTING.equals((Object)this.state)) {
            throw new IllegalStateException("Attempt to start GraphAware from multiple different threads. This is a bug");
        }
        if (!State.REGISTERED.equals((Object)this.state)) {
            throw new IllegalStateException("Illegal Runtime state " + (Object)((Object)this.state) + "! This is a bug");
        }
        startingThread.set(true);
        LOG.info("Starting GraphAware...");
        this.state = State.STARTING;
        this.startStatsCollector();
        this.startModules();
        this.startWriter();
        this.state = State.STARTED;
        LOG.info("GraphAware started.");
        startingThread.set(false);
    }

    private void startStatsCollector() {
        this.configuration.getStatsCollector().runtimeStart();
    }

    protected void startModules() {
        LOG.info("Loading module metadata...");
        Set<String> moduleIds = this.loadMetadata();
        this.cleanupMetadata(moduleIds);
        LOG.info("Module metadata loaded.");
    }

    private void startWriter() {
        this.getDatabaseWriter().start();
    }

    protected abstract Set<String> loadMetadata();

    protected abstract void cleanupMetadata(Set<String> var1);

    public final void waitUntilStarted() {
        if (!this.isStarted(null)) {
            throw new IllegalStateException("It appears that the thread starting the runtime called waitUntilStarted() before it's finished its job. This is a bug");
        }
    }

    protected final boolean isStarted(ImprovedTransactionData transactionData) {
        if (State.NONE.equals((Object)this.state)) {
            throw new IllegalStateException("Runtime has not been registered! This is a bug.");
        }
        if (State.SHUTDOWN.equals((Object)this.state)) {
            throw new IllegalStateException("Runtime is being / has been shut down.");
        }
        int attempts = 0;
        while (!State.STARTED.equals((Object)this.state)) {
            if (transactionData != null && !transactionData.mutationsOccurred()) {
                return false;
            }
            if (State.STARTING.equals((Object)this.state) && startingThread.get().booleanValue()) {
                return false;
            }
            try {
                if (++attempts > 100 && State.REGISTERED.equals((Object)this.state)) {
                    throw new IllegalStateException("Runtime has not been started!");
                }
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public final void beforeShutdown() {
        LOG.info("Shutting down GraphAware Runtime... ");
        this.state = State.SHUTDOWN;
        this.shutdownModules();
        this.stopWriter();
        this.afterShutdown();
        LOG.info("GraphAware Runtime shut down.");
    }

    protected void afterShutdown() {
    }

    protected abstract void shutdownModules();

    private void stopWriter() {
        this.getDatabaseWriter().stop();
    }

    public final void kernelPanic(ErrorState error) {
    }

    public final Object getResource() {
        return null;
    }

    public final KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
        return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
    }

    private static enum State {
        NONE,
        REGISTERED,
        STARTING,
        STARTED,
        SHUTDOWN;

    }
}

