/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.runtime.TxDrivenRuntime;
import com.graphaware.runtime.config.RuntimeConfiguration;
import com.graphaware.runtime.listener.TopologyChangeEventListener;
import com.graphaware.runtime.listener.TopologyListenerAdapter;
import com.graphaware.runtime.manager.TxDrivenModuleManager;
import com.graphaware.runtime.module.RuntimeModule;
import com.graphaware.runtime.module.TxDrivenModule;
import com.graphaware.writer.neo4j.Neo4jWriter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public class DatabaseRuntime
extends TxDrivenRuntime<TxDrivenModule> {
    private static final Log LOG = LoggerFactory.getLogger(DatabaseRuntime.class);
    private final GraphDatabaseService database;
    private final TxDrivenModuleManager<TxDrivenModule> txDrivenModuleManager;
    private final Neo4jWriter writer;
    private TopologyListenerAdapter topologyListenerAdapter;

    protected DatabaseRuntime(RuntimeConfiguration configuration, GraphDatabaseService database, TxDrivenModuleManager<TxDrivenModule> txDrivenModuleManager, Neo4jWriter writer) {
        super(configuration);
        this.database = database;
        this.txDrivenModuleManager = txDrivenModuleManager;
        this.writer = writer;
        database.registerTransactionEventHandler((TransactionEventHandler)this);
        database.registerKernelEventHandler((KernelEventHandler)this);
        try {
            this.topologyListenerAdapter = new TopologyListenerAdapter((GraphDatabaseAPI)database);
        }
        catch (Exception exception) {
            LOG.warn("Topology change adapter is not available on community edition");
        }
    }

    @Override
    protected TxDrivenModuleManager<TxDrivenModule> getTxDrivenModuleManager() {
        return this.txDrivenModuleManager;
    }

    @Override
    protected void doRegisterModule(RuntimeModule module) {
        if (module instanceof TxDrivenModule) {
            this.txDrivenModuleManager.registerModule((TxDrivenModule)module);
        }
        if (this.topologyListenerAdapter != null && module instanceof TopologyChangeEventListener) {
            this.topologyListenerAdapter.registerListener((TopologyChangeEventListener)module);
        }
    }

    @Override
    protected final void afterShutdown() {
        super.afterShutdown();
        this.afterShutdown(this.database);
        if (this.topologyListenerAdapter != null) {
            this.topologyListenerAdapter.unregister();
            this.topologyListenerAdapter = null;
        }
    }

    protected void afterShutdown(GraphDatabaseService database) {
    }

    public Neo4jWriter getDatabaseWriter() {
        return this.writer;
    }
}

