/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime;

import com.graphaware.runtime.GraphAwareRuntime;
import com.graphaware.runtime.ProductionRuntime;
import com.graphaware.runtime.config.FluentRuntimeConfiguration;
import com.graphaware.runtime.config.RuntimeConfiguration;
import com.graphaware.runtime.manager.ProductionTimerDrivenModuleManager;
import com.graphaware.runtime.manager.ProductionTxDrivenModuleManager;
import com.graphaware.runtime.metadata.GraphPropertiesMetadataRepository;
import org.neo4j.graphdb.GraphDatabaseService;

public final class GraphAwareRuntimeFactory {
    public static GraphAwareRuntime createRuntime(GraphDatabaseService database) {
        return GraphAwareRuntimeFactory.createRuntime(database, FluentRuntimeConfiguration.defaultConfiguration(database));
    }

    public static GraphAwareRuntime createRuntime(GraphDatabaseService database, RuntimeConfiguration configuration) {
        GraphPropertiesMetadataRepository timerRepo = new GraphPropertiesMetadataRepository(database, configuration, "TIMER_MODULE");
        GraphPropertiesMetadataRepository txRepo = new GraphPropertiesMetadataRepository(database, configuration, "TX_MODULE");
        ProductionTimerDrivenModuleManager timerDrivenModuleManager = new ProductionTimerDrivenModuleManager(database, timerRepo, configuration.getTimingStrategy(), configuration.getStatsCollector());
        ProductionTxDrivenModuleManager txDrivenModuleManager = new ProductionTxDrivenModuleManager(database, txRepo, configuration.getStatsCollector());
        return new ProductionRuntime(configuration, database, txDrivenModuleManager, timerDrivenModuleManager, configuration.getWritingConfig().produceWriter(database));
    }

    private GraphAwareRuntimeFactory() {
    }
}

