/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime;

import com.graphaware.runtime.DatabaseRuntime;
import com.graphaware.runtime.GraphAwareRuntime;
import com.graphaware.runtime.RuntimeRegistry;
import com.graphaware.runtime.config.RuntimeConfiguration;
import com.graphaware.runtime.manager.TimerDrivenModuleManager;
import com.graphaware.runtime.manager.TxDrivenModuleManager;
import com.graphaware.runtime.module.RuntimeModule;
import com.graphaware.runtime.module.TimerDrivenModule;
import com.graphaware.runtime.module.TxDrivenModule;
import com.graphaware.writer.neo4j.Neo4jWriter;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;

public class ProductionRuntime
extends DatabaseRuntime {
    private final TimerDrivenModuleManager timerDrivenModuleManager;

    protected ProductionRuntime(RuntimeConfiguration configuration, GraphDatabaseService database, TxDrivenModuleManager<TxDrivenModule> txDrivenModuleManager, TimerDrivenModuleManager timerDrivenModuleManager, Neo4jWriter writer) {
        super(configuration, database, txDrivenModuleManager, writer);
        this.timerDrivenModuleManager = timerDrivenModuleManager;
        if (RuntimeRegistry.getRuntime((GraphDatabaseService)database) != null) {
            throw new IllegalStateException("It is not possible to create multiple runtimes for a single database!");
        }
        RuntimeRegistry.registerRuntime((GraphDatabaseService)database, (GraphAwareRuntime)this);
    }

    @Override
    protected void startModules() {
        super.startModules();
        this.timerDrivenModuleManager.startModules();
    }

    @Override
    protected Set<String> loadMetadata() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(super.loadMetadata());
        result.addAll(this.timerDrivenModuleManager.loadMetadata());
        return result;
    }

    @Override
    protected void cleanupMetadata(Set<String> usedModules) {
        super.cleanupMetadata(usedModules);
        this.timerDrivenModuleManager.cleanupMetadata(usedModules);
    }

    @Override
    protected void checkNotAlreadyRegistered(RuntimeModule module) {
        super.checkNotAlreadyRegistered(module);
        this.timerDrivenModuleManager.checkNotAlreadyRegistered(module);
    }

    @Override
    protected void doRegisterModule(RuntimeModule module) {
        super.doRegisterModule(module);
        if (module instanceof TimerDrivenModule) {
            this.timerDrivenModuleManager.registerModule((TimerDrivenModule)module);
        }
    }

    @Override
    public <M extends RuntimeModule> M getModule(String moduleId, Class<M> clazz) throws NotFoundException {
        try {
            return super.getModule(moduleId, clazz);
        }
        catch (NotFoundException e) {
            M module = this.timerDrivenModuleManager.getModule(moduleId, clazz);
            if (module == null) {
                throw new NotFoundException("No module of type " + clazz.getName() + " with ID " + moduleId + " has been registered");
            }
            return module;
        }
    }

    @Override
    public <M extends RuntimeModule> M getModule(Class<M> clazz) throws NotFoundException {
        M result = null;
        try {
            result = super.getModule(clazz);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            M potentialResult = this.timerDrivenModuleManager.getModule(clazz);
            if (potentialResult != null) {
                if (result != null && potentialResult != result) {
                    throw new IllegalStateException("More than one module of type " + clazz + " has been registered");
                }
                result = potentialResult;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (result == null) {
            throw new NotFoundException("No module of type " + clazz.getName() + " has been registered");
        }
        return result;
    }

    @Override
    protected void shutdownModules() {
        super.shutdownModules();
        this.timerDrivenModuleManager.shutdownModules();
    }

    @Override
    protected void afterShutdown(GraphDatabaseService database) {
        super.afterShutdown(database);
        RuntimeRegistry.removeRuntime((GraphDatabaseService)database);
    }
}

