/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime;

import com.graphaware.runtime.BaseGraphAwareRuntime;
import com.graphaware.runtime.config.RuntimeConfiguration;
import com.graphaware.runtime.manager.TxDrivenModuleManager;
import com.graphaware.runtime.module.RuntimeModule;
import com.graphaware.runtime.module.TxDrivenModule;
import com.graphaware.tx.event.improved.api.ImprovedTransactionData;
import com.graphaware.tx.event.improved.api.LazyTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;

public abstract class TxDrivenRuntime<T extends TxDrivenModule>
extends BaseGraphAwareRuntime
implements TransactionEventHandler<Map<String, Object>> {
    protected TxDrivenRuntime(RuntimeConfiguration configuration) {
        super(configuration);
    }

    protected abstract TxDrivenModuleManager<T> getTxDrivenModuleManager();

    @Override
    protected void checkNotAlreadyRegistered(RuntimeModule module) {
        this.getTxDrivenModuleManager().checkNotAlreadyRegistered(module);
    }

    public Map<String, Object> beforeCommit(TransactionData data) throws Exception {
        LazyTransactionData transactionData = new LazyTransactionData(data);
        if (!this.isStarted((ImprovedTransactionData)transactionData)) {
            return null;
        }
        return this.getTxDrivenModuleManager().beforeCommit((TransactionDataContainer)transactionData);
    }

    public final void afterCommit(TransactionData data, Map<String, Object> states) {
        if (states == null) {
            return;
        }
        this.getTxDrivenModuleManager().afterCommit(states);
    }

    public final void afterRollback(TransactionData data, Map<String, Object> states) {
        if (states == null) {
            return;
        }
        this.getTxDrivenModuleManager().afterRollback(states);
    }

    public <M extends RuntimeModule> M getModule(String moduleId, Class<M> clazz) throws NotFoundException {
        M module = this.getTxDrivenModuleManager().getModule(moduleId, clazz);
        if (module == null) {
            throw new NotFoundException("No module of type " + clazz.getName() + " with ID " + moduleId + " has been registered");
        }
        return module;
    }

    public <M extends RuntimeModule> M getModule(Class<M> clazz) throws NotFoundException {
        return this.getTxDrivenModuleManager().getModule(clazz);
    }

    @Override
    protected Set<String> loadMetadata() {
        return this.getTxDrivenModuleManager().loadMetadata();
    }

    @Override
    protected void cleanupMetadata(Set<String> usedModules) {
        this.getTxDrivenModuleManager().cleanupMetadata(usedModules);
    }

    @Override
    protected void startModules() {
        super.startModules();
        this.getTxDrivenModuleManager().startModules();
    }

    @Override
    protected void shutdownModules() {
        this.getTxDrivenModuleManager().shutdownModules();
    }
}

