/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.bootstrap;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.runtime.GraphAwareRuntime;
import com.graphaware.runtime.GraphAwareRuntimeFactory;
import com.graphaware.runtime.config.Neo4jConfigBasedRuntimeConfiguration;
import com.graphaware.runtime.module.RuntimeModuleBootstrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class RuntimeKernelExtension
implements Lifecycle {
    private static final Log LOG = LoggerFactory.getLogger(RuntimeKernelExtension.class);
    public static final Setting<Boolean> RUNTIME_ENABLED = Settings.setting((String)"com.graphaware.runtime.enabled", (Function)Settings.BOOLEAN, (String)"false");
    public static final String MODULE_CONFIG_KEY = "com.graphaware.module";
    private static final Pattern MODULE_ENABLED_KEY = Pattern.compile("com\\.graphaware\\.module\\.([a-zA-Z0-9]{1,})\\.([0-9]{1,})");
    private final Config config;
    private final GraphDatabaseService database;

    public RuntimeKernelExtension(Config config, GraphDatabaseService database) {
        this.config = config;
        this.database = database;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        if (!((Boolean)this.config.get(RUNTIME_ENABLED)).booleanValue()) {
            LOG.info("GraphAware Runtime disabled.");
            return;
        }
        LOG.info("GraphAware Runtime enabled, bootstrapping...");
        GraphAwareRuntime runtime = GraphAwareRuntimeFactory.createRuntime(this.database, new Neo4jConfigBasedRuntimeConfiguration(this.database, this.config));
        this.registerModules(runtime);
        new Thread(() -> {
            if (this.database.isAvailable(300000L)) {
                runtime.start();
                LOG.info("GraphAware Runtime automatically started.");
            } else {
                LOG.error("Could not start GraphAware Runtime because the database didn't get to a usable state within 5 minutes.");
            }
        }, "GraphAware Starter").start();
        LOG.info("GraphAware Runtime bootstrapped, starting the Runtime...");
    }

    private void registerModules(GraphAwareRuntime runtime) {
        List<Pair<Integer, Pair<String, String>>> orderedBootstrappers = this.findOrderedBootstrappers();
        int lastOrder = -1;
        for (Pair<Integer, Pair<String, String>> bootstrapperPair : orderedBootstrappers) {
            int order = (Integer)bootstrapperPair.first();
            LOG.info("Bootstrapping module with order " + order + ", ID " + (String)((Pair)bootstrapperPair.other()).first() + ", using " + (String)((Pair)bootstrapperPair.other()).other());
            if (lastOrder == order) {
                LOG.warn("There is more than one module with order " + order + "! Will order clashing modules randomly");
            }
            lastOrder = order;
            try {
                RuntimeModuleBootstrapper bootstrapper = (RuntimeModuleBootstrapper)Class.forName((String)((Pair)bootstrapperPair.other()).other()).newInstance();
                runtime.registerModule(bootstrapper.bootstrapModule((String)((Pair)bootstrapperPair.other()).first(), this.findModuleConfig((String)((Pair)bootstrapperPair.other()).first()), this.database));
            }
            catch (Exception e) {
                LOG.error("Unable to bootstrap module " + bootstrapperPair.first(), (Throwable)e);
            }
        }
    }

    private List<Pair<Integer, Pair<String, String>>> findOrderedBootstrappers() {
        ArrayList<Pair<Integer, Pair<String, String>>> orderedBootstrappers = new ArrayList<Pair<Integer, Pair<String, String>>>();
        for (String paramKey : this.config.getConfiguredSettingKeys()) {
            Matcher matcher = MODULE_ENABLED_KEY.matcher(paramKey);
            if (!matcher.find()) continue;
            String moduleId = matcher.group(1);
            Integer moduleOrder = Integer.valueOf(matcher.group(2));
            String bootstrapperClass = (String)this.config.get((Setting)Settings.setting((String)paramKey, (Function)Settings.STRING, (String)Settings.MANDATORY));
            orderedBootstrappers.add((Pair<Integer, Pair<String, String>>)Pair.of((Object)moduleOrder, (Object)Pair.of((Object)moduleId, (Object)bootstrapperClass)));
        }
        Collections.sort(orderedBootstrappers, (o1, o2) -> Integer.compare((Integer)o1.first(), (Integer)o2.first()));
        return orderedBootstrappers;
    }

    private Map<String, String> findModuleConfig(String moduleId) {
        HashMap<String, String> moduleConfig = new HashMap<String, String>();
        String moduleConfigKeyPrefix = "com.graphaware.module." + moduleId + ".";
        for (String paramKey : this.config.getConfiguredSettingKeys()) {
            if (!paramKey.startsWith(moduleConfigKeyPrefix) && MODULE_ENABLED_KEY.matcher(paramKey).find()) continue;
            moduleConfig.put(paramKey.replace(moduleConfigKeyPrefix, ""), (String)this.config.getRaw(paramKey).get());
        }
        return moduleConfig;
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
    }
}

